import os as _os
import namednodes as _namednodes
import namednodes.accesses as _nn_accesses

def add_whr_toolkit(parent, path, service_type='master'):
    ''' Add WHR Toolkit hierarchy to named parent component '''
    from svtools.common import baseaccess

    from . import definition
    defpath = _os.path.dirname( _os.path.abspath(definition.__file__) )

    tile_def = _namednodes.GetComponentFromFile( _os.path.join(defpath, 'whr.lmdb') )

    if hasattr(parent, 'whr_10'):
        tile = getattr(parent, 'whr_10')
    else:
        tile = parent.add_component( tile_def.create('whr_10') )

    tile.target_info.service_type = service_type

    for instance in range(4):
        quad = tile.add_component( tile_def.phy_quad0.create('phy_quad%d'%instance) )
        quad.target_info.region_offset = (6 << 21) | (0x10000 << instance)

        phy_def = _namednodes.GetComponentFromFile( _os.path.join(defpath, 'whr_phy.lmdb') )
        comp   = quad.add_component( phy_def.syn_phy.create_tree('syn_phy') )

        quad.target_info.device = path
        quad.set_access('vjtag')

    if baseaccess.getaccess() == 'stub':
        tile.access_classes['AccessVJTAG2AVMM']  = _nn_accesses.general.AccessRegisterStoredValues
        tile.access_classes['AccessWHR_SYN_PHY'] = _nn_accesses.general.AccessRegisterStoredValues
    else:
        import pysv_fpga.toolext.namednodes.accesses.classes
        tile.access_classes['AccessVJTAG2AVMM']  = pysv_fpga.toolext.namednodes.accesses.classes.AccessVJTAG2AVMM_1BYTE_SHIFT
        tile.access_classes['AccessWHR_SYN_PHY'] = pysv_fpga.toolext.namednodes.accesses.classes.AccessWHR_SYN_PHY

    for instance in range(4):
        avmm = tile.add_component( tile_def.pcie_avmm0.create('pcie_avmm%d'%instance) )
        avmm.target_info.region_offset = ((instance + 1) << 21) | 0x104000

        avmm.target_info.device = path
        avmm.set_access('vjtag')
        hip_ctrl = avmm.hip_ctrl.read()

        pcie_def = _namednodes.GetComponentFromFile( _os.path.join(defpath, 'whr_pcie.lmdb') )

        ep_map = {
                0: pcie_def.port0.ep_cfg_avmm,      #X16 EP
                1: pcie_def.port1.ep_cfg_avmm,      #X8  EP
                2: pcie_def.port2_3.ep_cfg_avmm,    #X4  EP
                3: pcie_def.port2_3.ep_cfg_avmm,    #X4  EP
                }
        rp_map = {
                0: pcie_def.port0.rp_cfg_avmm.pf0,  #X16  RP
                1: pcie_def.port1.rp_cfg_avmm.pf0,  #X8  RP
                2: pcie_def.port2_3.rp_cfg_avmm.pf0,#X4  RP
                3: pcie_def.port2_3.rp_cfg_avmm.pf0,#X4  RP
                }

        if hip_ctrl.k_device_type == 0:
            port_def  = ep_map[ instance ]
        else:
            port_def  = rp_map[ instance ]

        port_name = 'pcie_rp%d'%instance if hip_ctrl.k_device_type else 'pcie_ep%d'%instance
        port      = tile.add_component( port_def.create_tree( port_name ) )
        port.target_info.region_offset = (instance + 1) << 21

        if hasattr(port, 'pfs'):
            for i, pf in enumerate(port.pfs):
                pf.target_info.region_offset = (instance + 1) << 21 | i * 0x1000
                for register in pf.registers:
                    pf.getregisterobject(register).definition.info.addressOffset &= 0xfff

        port.target_info.device = path
        port.set_access('vjtag')

        if hip_ctrl.k_device_width == 0:
            if baseaccess.getaccess() == 'systemconsole':
                break  # Only expose 1 port if x16
        if instance == 1 and hip_ctrl.k_device_width == 1:
            if baseaccess.getaccess() == 'systemconsole':
                break  # Only expose 2 ports if x8s

    return tile.path
