import socket
import re
import time

class SysconSocketApi():
    """
    Class used to communicate to Quartus using sockets as IPC
    """
    def __init__(self,host,port,size,conn=None):
        self.host=host
        self.port=port
        self.size=size
        self.conn = conn

    def open(self, retry_number):
        """
        creates the connection between the tcl server in quartus.
        update the conn attribute when completed

        parameters:
            retry_number -> number of retries before trigger an exception
        """
        if self.conn == None:
            #If the connection has not been created
            for retry in range(0,retry_number):
                try:    # nosec
                    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                    s.connect(( self.host, self.port))
                    self.conn = s
                    self.conn.settimeout(45)
                    return
                except:
                    continue
            raise SysconConnectionError("Unable to connect with Quartus")
        else:
            #Connection has been already established
            return

    def close(self):
        """
        Used to close the socket communication
        """
        if self.conn == None:
            raise SysconConnectionError("Unable to close a port that is not opened")
        else:
            self.conn.close()
            self.conn = None

    def _command_send(self,command):
        """
        used to send commands from python to tcl console
        """
        try:
            #Newline is required to flush the buffer on the Tcl server
            self.conn.send('{}\n'.format(command).encode())
        except:
            raise
            #raise SysconConnectionError("Unable reach Quartus for command  send. " + \
                                        #"Please restart the console")
    def _command_receive(self):
        """
        Used to retrieve data from the tcl server
        """

        try:
            ##Read teh data until the end key is received to support strings
            ##longer that socket size
            #Variable used to store the key
            key = ""
            #Variable used
            data = ""
            #Variable used to store the server message
            received_msg  = ""
            #Loop until key is received
            while True:
                received_msg = self.conn.recv(self.size)
                received_msg = str(received_msg.decode('ascii'))
                data += received_msg
                if data.endswith('\n'):
                    for line in data.split('\n'):
                        if line.startswith('return'):
                            # Message is in quotes
                            return line.split('"')[1]
                        if line.startswith('error'):
                            # Message is in quotes
                            raise Exception( line.split('"')[1] )
        except socket.timeout:
            raise SysconConnectionError("System console command timed out after waiting for 45 seconds")
        except:
            raise
            #raise SysconConnectionError("Unable reach Quartus for command retrieve." + \
                                        #"Please restart the console")

    def command_wrapper(self,command_obj):
        """
        End to end communication with tcl server
        """
        self._command_send(command_obj)
        return self._command_receive()

#### Read For Error exceptions:
class SysconConnectionError(Exception):
    """
    Quartus connection exception, used to report any
    issue related with quartus interface
    """
    def __init__(self,message):
        #Logging information
        self.msg = message
        self.value = "[Quartus Connection Error]: " + self.msg
    def __str__(self):
        return repr(self.value)
