"""
name:
    SysconInteface.py

description:
    Contains system console command interface and Tcp socket interface to System-console
    Please import syscon_interface instance when accessing System Console functions and
    call start_syscon() to initialize System console.


Revision:
    5/31/2018: First creation (Modified from S10 PythonSV code)

"""

import os
import re

from pysv_fpga.fpga_tools.quartus.SysconCommands import command_parser
import pysv_fpga.fpga_tools.quartus.SysconConnection as syscon_connection

SysconCommand_xml = "SysconCommands.xml"

class SysconInterface(object):
    """
    Class used to communicate to SystemConsole
    """

    SysconCntr = 0
    Syscon_proc = None
    Syconc_api  = None

    def __init__(self):
        pass

    def start_syscon(self, port=None, close=True):

        # Checks if System Console is ready
        if self.SysconCntr == 0:
            syscon = syscon_connection.open_console(port=port) # start system console and socket client
            if syscon != None:
                self.Syscon_proc, self.Syscon_api = syscon
                self.SysconCntr += 1

        # quartus_command.xml is in same dir
        xml_base = os.path.dirname(__file__)
        xml_command_file = SysconCommand_xml
        #parse the commands
        parser = command_parser( os.path.join(xml_base, xml_command_file), self.Syscon_api )
        self.commands = parser._parsed_commands()

# Import this instance
syscon_interface = SysconInterface()
