"""
Name:
    SysconConnection.py

Description:
    This module contains System Console connection management functions.
    System console runs Tcp server that receives Tcl commands.
    Tcp client sends System Console command to the server and receives result.

History:
    6/5/2018 Ported from S10 PythonSV
"""

from pysv_fpga.fpga_tools.quartus.SysconSocketApi import SysconSocketApi, SysconConnectionError
import sys
import os
import signal
import re
import time
import getpass
import socket
import codecs
from time import sleep


class Syscon_conf:
    connection_retries = 50
    proc = None
    server_host = 'localhost'
    # Set unique port number above 1024
    server_port = abs(int(codecs.encode('{}{}'.format(socket.gethostname(),getpass.getuser()).encode(), 'hex'), 16)) % (65535 - 1024)
    socket_size = 0x10000

    tcl_sock = os.path.normpath(os.path.join( os.path.dirname(__file__), '..', 'tcl', 'local_tcp_ip.tcl'))

    syscon_disp = True

    executable = None

    def __init__(self):
        pass

    def parse_conf(self):
        from svtools.common.pysv_config import CFG

        for option in CFG.systemconsole.options():
            if hasattr(Syscon_conf, option):
                if option in ['syscon_disp','connection_retries','port','socket_size']:
                    setattr(Syscon_conf, option, int(getattr(CFG.systemconsole, option)))
                else:
                    setattr(Syscon_conf, option, getattr(CFG.systemconsole, option))

        # If in ARC shell, assume exe is in path
        if ('ARC_JOB_ID') in os.environ and \
           (('SOPC_KIT_NIOS2TEST' in os.environ or ('QUARTUS_ROOTDIR') in os.environ)):
            Syscon_conf.executable = os.path.basename(Syscon_conf.executable)
        elif not os.path.exists( self.executable ):
            raise Exception('The System Console path specified in pysv_config.ini does not exist, please run pysv_config.py again and select another version')


def open_console( **kw ):
    port = kw.get('port', None)
    if port is not None:
        Syscon_conf.server_port = port

    syscon_api = SysconSocketApi( Syscon_conf.server_host,
                                    Syscon_conf.server_port,
                                    Syscon_conf.socket_size )

    # Attempt to connect to existing System Console instance
    syscon_api.open(retry_number = 1)
    rcv = syscon_api.command_wrapper( 'set echo "HELLO"' )
    if rcv == 'HELLO':
        return None, syscon_api


def is_open( syscon_api ):
    """check if server is still alive"""
    try:
        rcv = syscon_api.command_wrapper( 'set echo "HELLO"' )
        if rcv == 'HELLO':
            return True
        else:
            return False
    except SysconConnectionError:
        return False

