"""
Defines commands specific to the whr_toolkit
"""
import pysv_fpga.commands.general as general


class Commands(general.Commands):

    @staticmethod
    def not_implemented(args):
        raise NotImplementedError()  # todo: call the real thing

    def eye_diagram(self, path, lane=0, port=0):
        self.logger.warn("Executing 'eye_diagram' command: path=%s, lane=%i, port=%i"%( path, lane, port))
        from namednodes import sv

        reg_path = path + '.pcie_avmm' + str(port) + '.hip_debug_status_register'
        reg_obj = sv.get_by_path(reg_path)
        print("##", reg_path, '=', hex(reg_obj.read()))
        '''
        >>> sv.fpga0.whr_10.pcie_avmm0.hip_debug_status_register.show
        0x00000000 : max_payload_size (31:29) -- Max Payload Size Control for PF0 only
        0x00000000 : reserved (28:20) -- Reserved
        0x00000008 : link_speed (19:16) -- Negotiated Link speed from DWIP
        0x00000000 : reserved_other (15:14) -- Reserved
        0x00000010 : link_width (13:08) -- Negotiated Link Width from DWIP
        0x00000000 : warm_reset_request (07:07) -- Warm Reset Request from DWIP
        0x00000001 : link_up (06:06) -- Link_Up status from DWIP
        0x00000011 : ltssm_state (05:00) -- L0 -- LTSSM state from DWIP
        '''

        eyeData = {
            "status" : "OK",
            "status_desc" : "",
            "x_unit" : "Phase Step",
            "y_unit" : "Vertical Step",
            "z_unit" : "BER",
            "z_unit_type" : "BER",
            "z_legend" : "",
            "color_map" : { 0: (50,50,50), 1: (250,0,0), 2: (0,250,0), 4: (0,0,250)},
            "pixel_to_z_value_map" : {'1': 1e0, '2': 1e-5, '4': 1e-12},
        }
        tile = sv.get_by_path(path)
        import pysv_fpga.ptile.whrPhy as w
        import pysv_fpga.ptile.whrPhyMargin as wm
        portID = 'p' + str(port)
        result = wm.findEyeRepeat(tile, portID, lane=lane, eyeType="o", trialCnt=1,showPlot=False,logResults=True,returnRpcData=True)
        level_1 = list(result.keys())[0]
        print("# 1:    result.keys() =", result.keys())
        print("# 2:    len(result[", level_1, "]) = ", len(result[level_1]))
        print("# 3.0:  result[level_1][0].keys() =", result[level_1][0].keys())
        print("# 3.1:  result[level_1][1].keys() =", result[level_1][1].keys())
        level_3_0 = list(result[level_1][0].keys())[0]
        ep = result[level_1][0][level_3_0][0]
        eyeData["eye_ctr_lt"] = abs( ep['strtVco'] - ep['vcoL'] )
        eyeData["eye_ctr_rt"] = abs( ep['strtVco'] - ep['vcoR'] )
        eyeData["eye_ctr_up"] = abs( ep['dseh']['strtVoc'] - ep['dseh']['vocU'] )
        eyeData["eye_ctr_dn"] = abs( ep['dseh']['strtVoc'] - ep['dseh']['vocD'] )
        #print("==> Eye contour data:")
        x_to_ud_dict = dict()
        for k, v in result[level_1][1].items():
            x_to_ud_dict[int(v['vco'])] = {'up': int(v['dsehU']), 'dn': int(v['dsehD'])}
        import pysv_fpga.ptile.pixmap as px
        pxud = px.process_xud(x_to_ud_dict)
        pxmap = px.pixelize(pxud)
        #pxmap.show()
        eyeData["pixel_map"] = pxmap._pixmap
        eyeData["x_step"] = 1 / pxmap._x_scale
        eyeData["y_step"] = 1 / pxmap._y_scale
        eyeData["x_axis_offset"] = - pxmap._x0
        eyeData["y_axis_offset"] = - pxmap._y0
        return eyeData


class BogusCommands(general.BogusCommands):
    """
    Holds commands that should execute without a target or any PythonSV
    dependencies --i.e. for true "unit" tests and proving out compatibility
    """

    def eye_diagram(self, **kwargs):
        """runs without a target, should return good static eye_diagram data"""
        # todo: replace with known good data
        return get_bogus_eye_data()


def get_bogus_eye_data():
    return {
        "status" : "OK",
        "status_desc" : "",
        "x_step" : 5,
        "y_step" : 10,
        "x_axis_offset" : 10,
        "y_axis_offset" : -40,
        "x_unit" : "This is x-axis label name",
        "y_unit" : "This is x-axis label name",
        "z_unit" : "This is z-axis label name",
        "z_unit_type" : "This is z unit legend value type",
        "z_legend" : "This is z legend string",
        # color_map translates numbers from pixel_map to RGB triad
        "color_map" : { 0: (250,0,0), 1: (0,250,0), 2: (0,0,250) },
        "pixel_to_z_value_map" : {'0': 1e0, '1': 1e-5, '2': 1e-10},
        "pixel_map" : (
            (0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
            (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
            (0, 0, 0, 1, 2, 2, 1, 0, 0, 0),
            (0, 0, 1, 2, 2, 2, 2, 1, 0, 0),
            (0, 1, 2, 2, 2, 2, 2, 2, 1, 0),
            (0, 1, 2, 2, 2, 2, 2, 2, 1, 0),
            (0, 0, 1, 2, 2, 2, 2, 1, 0, 0),
            (0, 0, 0, 1, 2, 2, 1, 0, 0, 0),
            (0, 0, 0, 0, 1, 1, 0, 0, 0, 0),
            (0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
        ),
        "eye_ctr_lt" : 7,
        "eye_ctr_rt" : 6,
        "eye_ctr_up" : 5,
        "eye_ctr_dn" : 5
    }
