
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.


"""
Store miscellaneous function for when working with XML.
"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from xml.etree import ElementTree as _ET

# code from here
# http://stackoverflow.com/questions/749796/pretty-printing-xml-in-python
def indent(elem, level=0, more_sibs=False):
    i = "\n"
    if level:
        i += (level-1) * '  '
    num_kids = len(elem)
    if num_kids and getattr(elem[0],"tag","").count("CDATA")==0:
        if not elem.text or not elem.text.strip():
            elem.text = i + "  "
            if level:
                elem.text += '  '
        count = 0
        for kid in elem:
            indent(kid, level+1, count < num_kids - 1)
            count += 1
        if not elem.tail or not elem.tail.strip():
            elem.tail = i
            if more_sibs:
                elem.tail += '  '
    else:
        if level and (not elem.tail or not elem.tail.strip()):
            elem.tail = i
            if more_sibs:
                elem.tail += '  '
prettyprint = indent

# elementree cdata support
# http://www.kaarsemaker.net/blog/2013/10/10/cdata-support-in-elementtree/
def CDATA(text=None):
    element = _ET.Element('![CDATA[')
    element.text = text
    return element

# add CDATA support to ET Python 2.7 and 3
if hasattr(_ET, '_serialize_xml'):
    # only override if have to
    if not hasattr(_ET,"_original_serialize_xml"):
        _ET._original_serialize_xml = _ET._serialize_xml
        def _serialize_xml(write, elem, *args, **kwargs):
            if elem.tag == '![CDATA[':
                write("<%s%s]]>" % (
                    elem.tag, elem.text))
                return
            return _ET._original_serialize_xml(write, elem, *args, **kwargs)
        _ET._serialize_xml = _ET._serialize['xml'] = _serialize_xml

