
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.




"""
"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ._py2to3 import *
import operator

class WrappedValue(object):
    """This object passes on any numeric operations to _value. If _value is None
    then get_value is called
    Inherited classes must set:
        - value_type
    """
    # default user type is long
    # class variable to keep up with what value types we support mimicing
    _val_types = ['long','int','str','basestring','float']
    # attributes that must be specified in the init
    __slots__ = ['_value','_value_type']
    def __init__(self,value,value_type = long):
        # these
        self.value = value
        self.value_type = value_type
    def get_value(self):
        raise Exception("must be implemented by inherited classes")
    def __long__(self):
        if self._value is None: self.get_value()
        return self._value.__long__()
    def __int__(self):
        if self._value is None: self.get_value()
        return self._value.__int__()
    def __abs__(self):
        if self._value is None: self.get_value()
        return operator.abs(self._value)
    def __add__(self,other):
        if self._value is None: self.get_value()
        return operator.add(self._value, other)
    def __and__(self,other):
        if self._value is None: self.get_value()
        return operator.and_(self._value, other)
    def __cmp__(self,other):
        if self._value is None: self.get_value()
        # operator? or just cmp?
        return self._value.__cmp__(other)
    def __coerce__(self,other):
        if self._value is None: self.get_value()
        return self._value.__coerce__(other)
    def __div__(self,other):
        if self._value is None: self.get_value()
        return operator.div(self._value, other )
    def __float__(self):
        if self._value is None: self.get_value()
        return self._value.__float__()
    def __floordiv__(self,other):
        if self._value is None: self.get_value()
        return operator.floordiv(self._value, other)
    def __hex__(self):
        if self._value is None: self.get_value()
        return self._value.__hex__()
    def __index__(self):
        if self._value is None: self.get_value()
        return self._value.__int__()
    def __invert__(self):
        if self._value is None: self.get_value()
        return operator.invert(self._value)
    def __complex__(self):
        if self._value is None: self.get_value()
        return self._value.__complex__()
    def __lshift__(self,other):
        if self._value is None: self.get_value()
        return operator.lshift(self._value, other)
    def __mod__(self,other):
        if self._value is None: self.get_value()
        return operator.mod(self._value, other)
    def __mul__(self,other):
        if self._value is None: self.get_value()
        return operator.mul(self._value,other)
    def __neg__(self):
        if self._value is None: self.get_value()
        return operator.neg(self._value)
    def __nonzero__(self):
        if self._value is None: self.get_value()
        return self._value.__nonzero__()
    def __bool__(self):
        if self._value is None: self.get_value()
        return self._value.__bool__()
    def __oct__(self):
        if self._value is None: self.get_value()
        return self._value.__oct__()
    def __or__(self,other):
        if self._value is None: self.get_value()
        return operator.or_(self._value, other)
    def __pos__(self):
        if self._value is None: self.get_value()
        return operator.pos(self._value)
    def __pow__(self,other):
        if self._value is None: self.get_value()
        return operator.pow(self._value, other)
    # Right hand side begins here
    def __radd__(self,other):
        if self._value is None: self.get_value()
        return operator.add(other, self._value)
    def __rand__(self,other):
        if self._value is None: self.get_value()
        return operator.and_(other, self._value)
    def __rdiv__(self,other):
        if self._value is None: self.get_value()
        return operator.div(other, self._value)
    def __rfloordiv__(self,other):
        if self._value is None: self.get_value()
        return operator.floordiv(other, self._value)
    def __rlshift__(self,other):
        if self._value is None: self.get_value()
        return operator.lshift(other, self._value)
    def __rmod__(self,other):
        if self._value is None: self.get_value()
        return operator.mod(other, self._value)
    def __rmul__(self,other):
        if self._value is None: self.get_value()
        return operator.mul(other, self._value)
    def __ror__(self,other):
        if self._value is None: self.get_value()
        return operator.or_(other, self._value)
    def __rpow__(self,other):
        if self._value is None: self.get_value()
        return operator.pow(other, self._value)
    # NOT a right handop:
    def __rshift__(self,other):
        if self._value is None: self.get_value()
        return operator.rshift(self._value, other)
    # back to right hand ops:
    def __rrshift__(self,other):
        if self._value is None: self.get_value()
        return operator.rshift(other, self._value)
    def __rsub__(self,other):
        if self._value is None: self.get_value()
        return operator.sub(other, self._value)
    def __rtruediv__(self,other):
        if self._value is None: self.get_value()
        return operator.truediv(other, self._value)
    def __rxor__(self,other):
        if self._value is None: self.get_value()
        return operator.xor(other, self._value)
    def __sub__(self,other):
        if self._value is None: self.get_value()
        return operator.sub(self._value, other)
    def __truediv__(self,other):
        if self._value is None: self.get_value()
        return operator.truediv(self._value, other)
    def __xor__(self,other):
        if self._value is None: self.get_value()
        return operator.xor(self._value, other)
    def __str__(self):
        #if self._value is None: self.get_value()
        return self.__repr__()
    def __hash__(self):
        if self._value is None: self.get_value()
        return hash(self._value)
    def __lt__(self,other):
        if self._value is None: self.get_value()
        return (self._value<other)
    def __le__(self,other):
        if self._value is None: self.get_value()
        return (self._value<=other)
    def __eq__(self,other):
        if self._value is None: self.get_value()
        return (self._value==other)
    def __ne__(self,other):
        if self._value is None: self.get_value()
        return (self._value!=other)
    def __gt__(self,other):
        if self._value is None: self.get_value()
        return (self._value>other)
    def __ge__(self,other):
        if self._value is None: self.get_value()
        return (self._value>=other)
    def __format__(self,format_spec):
        if format_spec.count("s") or format_spec=="":
            return format( repr(self), format_spec )
        else: # assume it wants our number format
            return format( self._value_type(self), format_spec )
    def __repr__(self):
        if self._value is None:
            self.get_value()
        if self._value_type == long:
            if self._value is None:
                raise Exception("Value still None for long type")
            return hex(long(self._value))
        #elif self._value_type == float:
        #    return repr(float(self._value)
        else:
            return self._value.__repr__()
