

# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.




from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import six
import functools
import re

# stolen with pride from an SV team
def alpha_numeric_cmp(x,y):
    '''
    Smart compare function. Given two strings will return:
        -1 if first string should precede the second
         0 if strings are equal
         1 if second string should precede the first
    Unlike normal compare this function takes into account numerical value for integers (base 10) embedded into the string
    Example:
        >>? alpha_numeric_cmp('test2_file','test10_file')
        -0x1
    '''
    while(1):
        mxa = re.match(r"^(\D+)",x)
        mya = re.match(r"^(\D+)",y)
        mxn = re.match(r"^(\d+)",x)
        myn = re.match(r"^(\d+)",y)
        mx = None
        my = None
        if (mxa != None or mya != None):
            mx = "" if mxa == None else mxa.group(1)
            my = "" if mya == None else mya.group(1)
        else:
            mx = "" if mxn == None else int(mxn.group(1))
            my = "" if myn == None else int(myn.group(1))

        if mx != my:
            mx_is_int = isinstance(mx,six.integer_types)
            my_is_int = isinstance(my,six.integer_types)
            # both ints or both not ints
            if (mx_is_int and my_is_int) or (not my_is_int and not mx_is_int):
                return (mx > my) - (mx < my)
            elif mx_is_int:
                return  1  # x is string, y is int, x is >
            elif my_is_int:
                return -1  # x is int, y is str, y is >
            else:
                # not sure what we hit here so fall back on old flow
                return (mx > my) - (mx < my)

        else:
            x = x.replace(str(mx),"")
            y = y.replace(str(my),"")
        if (x == "") and (y == ""):
            return 0x0

