

# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import importlib


def str2py(astring):
    """
    convert the string of in to a python object. The string must be of the foramat:
        package.module:object

    Args:
        astring (str) : string to convert to an object

    Returns:
        python object

    """
    try:
        module, oname = astring.split(":")
    except:
        raise ValueError("string %s did not match the expected format of package.module:object" % (
                        astring))
    module = importlib.import_module(module)
    try:
        # should have what we need at this point
        return getattr(module, oname)
    except:
        raise ValueError("couldn't find the object %s in the module %s"%(oname, module))


