import re
from collections import namedtuple
from namednodes import CreateComponentDefinition
from ..logging import getLogger
from ..plugins.nn_formula import FormulaParts
_LOG = getLogger()
class barCrawler:    
    def get_top_component(self, comp):
        """Recursive, just tries to find the first component that has 'formulas' in it."""
        if comp is None:
            return None            
        if 'formulas' in comp.info:
            return comp
        else:            
            return self.get_top_component(comp.parent)

    def bar_update_by_brute_force(self, obj, new_name, action):
        import re
        the_component_with_bars = self.get_top_component(obj)
        if the_component_with_bars:
            _LOG.info("Bar update due to mover action")
            bars = the_component_with_bars.info.get('formulas', None)
            tmp_path = obj.name
            if bars:
                for barname, barcontents in bars.items():
                    flag_modified = False
                    if not isinstance(barcontents, FormulaParts):
                        _LOG.debug(f"Skip moving {barname} since it is not a FormulaParts bar")
                        continue
                    for bar_part in barcontents.parts:
                        form_bar_path = bar_part.component_path
                        if form_bar_path.find(tmp_path) > -1:
                            if action == _ComponentAction.sub_path:
                                temp_obj_path = obj.path
                                if temp_obj_path.find(obj.origin.name + ".") ==0: #just at the beginning
                                    temp_obj_path = temp_obj_path.replace(obj.origin.name + ".", "")
                                new_path = re.sub(r"(?:\.|^){name}$".format(name=temp_obj_path),new_name, form_bar_path)
                                if new_path != form_bar_path:
                                    bar_part.component_path = new_path
                                    _LOG.info(f"Bar {form_bar_path} -- > {bar_part.component_path}")
                                    flag_modified = True
                            elif action == _ComponentAction.sub_name:
                                new_2name = re.sub(r"(?:\.|^){name}(?:\.|$)".format(name=obj.name), "."+new_name+".",form_bar_path)
                                if new_2name != form_bar_path:
                                    bar_part.component_path = new_2name
                                    _LOG.info(f"Bar {form_bar_path} -- > {bar_part.component_path}")
                                    flag_modified = True
                    if flag_modified:                    
                        if 'formulas' not in the_component_with_bars.target_info:
                            the_component_with_bars.target_info['formulas']={}
                        the_component_with_bars.target_info['formulas'][barname]=barcontents
                        flag_modified = False        



class _ComponentAction:
    sub_path = 1  # path
    sub_name = 2  # just name
    remove_path = 3  # remove based on path
    remove_name = 4  # remove based on name


_Action = namedtuple("Action", ["action", "start", "finish"])
# action = action type from _ComponentAction
# start = the regular expression to match on
# finish = the finished value (moved, renamed, etc...)


class ComponentMover:
    def __init__(self, component):
        """
        Args:
              ComponentValue object, all regular expressions are considered to be relative the specified component
        """
        # maybe not the "true" origin, but the origin for all of "our" work
        self._origin = component
        self._actions = []

    def sub_path(self, start, finish):
        """
        Uses re.sub to change the path of any component matching the 'start' regex

        Args:
             start: regular expression to check path against
             finish: final path (with format characters for captured res)
                - this can also be a function where the component matching the start will be passed in
                - if a function is provided it should return a new path
        Returns:
            nothing, but the component starting component structure may be modified
        """
        action = _Action(_ComponentAction.sub_path, re.compile(start), finish)
        self._actions.append(action)

    def sub_name(self, start, finish):
        """
        Uses re.sub to change the name of any component matching the 'start' regex

        Args:
             start: regular expression to check path against
             finish: final path (with format characters for captured res)
                - this can also be a function where the component matching the start will be passed in
                - if a function is provided it should return a new path
        Returns:
            nothing, but the component starting component structure may be modified
        """
        action = _Action(_ComponentAction.sub_name, re.compile(start), finish)
        if start in self._actions:
            raise RuntimeError("that path (%s) is already set for a previous action" % start)
        self._actions.append(action)

    def remove(self, name=None, path=None):
        """
        Uses re.sub to remove any component matching the specified name or path regular expression provided

        Args:
            removes any components (completely) whose name that match the given regular expression
        """
        if name:
            action = _Action(_ComponentAction.remove_name, re.compile(name), None)
        elif path:
            action = _Action(_ComponentAction.remove_path, re.compile(path), None)
        else:
            raise ValueError("Must specify name or path")
        self._actions.append(action)

    def _merge_dict(self, orig_dict, incoming_dict):
        import collections.abc
        for k, v in incoming_dict.items():
            if isinstance(v, collections.abc.Mapping):
                orig_dict[k] = self._merge_dict(orig_dict.get(k, {}), v)
                continue
            orig_v = orig_dict.get(k, KeyError)
            if orig_v != KeyError and orig_v != v:
                print("Warning!")
            else:
                orig_dict[k] = v
        return orig_dict

    def _add_or_create_component(self, new_path, component, original_path):
        # creates any intermediate components needed to add to the path for the final component
        next = self._origin
        path_parts = new_path.split(".")
        num_parts = len(path_parts)
        for p, name in enumerate(path_parts):
            next_c = next.sub_components.get(name, None)
            # missing sub component but not on the last one yet
            if next_c is None and p < num_parts - 1:
                temp_def = CreateComponentDefinition(name=name, value_class=next.definition.value_class)
                next_c = temp_def.create(name)
                next.add_component(next_c)
            elif p == (num_parts - 1):
                # on the last piece
                component.name = name
                if component.name not in next.sub_components:
                    next.add_component(component)
                    component.target_info.setdefault('original_paths', []).append(original_path)
                else:
                    self._merge_dict(next.sub_components[component.name].target_info, component.target_info)                    
                    for node in component.definition.nodes:
                        next.sub_components[component.name].definition.add_node(node)
                    
                    

                return
            # on to the next one
            next = next_c




    def run(self):
        """
        Walks all the components and applies the queued actions
        """
        starting_path = self._origin.path
        CompUpdate = namedtuple("comp_update", ["comp", "new_path"])
        components_to_rename = []
        components_to_move = []
        components_to_remove = []
        # this list should not do any actual add/removes but instead finds the components that should be added
        # and/or removed        
        for comp in self._origin.walk_components():
            # if comp.name.startswith("buttress")
            for action in self._actions:
                check_path = comp.path.replace(starting_path + ".", "")
                # means we are just removing
                if action.action == _ComponentAction.remove_path:
                    if action.start.match(check_path):
                        components_to_remove.append(comp)
                if action.action == _ComponentAction.remove_name:
                    if action.start.match(comp.name):
                        components_to_remove.append(comp)
                elif action.action == _ComponentAction.sub_path:
                    # substitution may be name or path
                    new_path = action.start.sub(action.finish, check_path)
                    if new_path != check_path:
                        components_to_move.append(CompUpdate(comp, new_path))
                elif action.action == _ComponentAction.sub_name:
                    new_name = action.start.sub(action.finish, comp.name)
                    if new_name != comp.name:
                        components_to_rename.append(CompUpdate(comp, new_name))
        barcrawler = barCrawler()
        for comp, new_name in components_to_rename:
            barcrawler.bar_update_by_brute_force(comp, new_name, _ComponentAction.sub_name)
            parent = comp.parent
            parent.remove_component(comp.name)
            comp.name = new_name
            parent.add_component(comp)
        for comp, new_path in components_to_move:
            barcrawler.bar_update_by_brute_force(comp, new_path, _ComponentAction.sub_path)
            orig_path = comp.path
            comp.parent.remove_component(comp.name)
            self._add_or_create_component(new_path, comp, orig_path)
        # make the remove go last
        for comp in components_to_remove:
            comp.parent.remove_component(comp.name)