
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.
"""
.. autofunction:: bits
.. autofunction:: reverseBits
.. autofunction:: getbits
.. autofunction:: setbits
.. autofunction:: getindices
.. autofunction:: binstr2num
.. autofunction:: num_to_buffer
.. autofunction:: buffer_to_num



"""


from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ._py2to3 import *

import binascii
import ctypes
import struct
import math

# this is meant to act exactly like the ITP bits and has NO ERROR CHECKING
# it is a copy and paste since from corecode since this is suppose to be
# a utils for even corecode and therefore should not import corecode
# this is meant to act exactly like the ITP bits and has NO ERROR CHECKING
def bits(value,lowerbit,numbits,bitvalue=None):
    if bitvalue is None:
        newvalue = value>>lowerbit
        return newvalue & ((1<<numbits)-1)
    # we're doing a write
    mask = ((1<<numbits)-1)<<lowerbit
    newvalue = value & ~mask
    newvalue = newvalue | (bitvalue<<lowerbit)
    return newvalue



def reverseBits(value,numbits):
    """This function does reverses every bit and returns the reversed value"""
    # 4 bit value
    # 1110 -> 0111
    newvalue = 0
    for i in range(numbits):
        # reverse one bit at a time
        newvalue |= ((value>>i)&1) << (numbits-i-1)
    return newvalue


def getbits(value, upperbit, lowerbit):
    """Gets bits specified in the value and returns the bitvalue."""
    if type(value) not in [int, long]:
        if type(value) is str:
            value = long(value,0)
        else:
            value = long(value)
    if (upperbit < lowerbit) or (lowerbit < 0):
        raise ValueError('upperbit=%d, lowerbit=%d' % (upperbit, lowerbit))
    bitvalue = value >> lowerbit
    bitvalue &= int(pow(2, (upperbit - lowerbit + 1)) - 1)
    return bitvalue

def setbits(value, upperbit, lowerbit, bitvalue):
    """Sets bits specified in the value to bitvalue and returns new value."""
    # if value or bitvalue are not integers, then convert them
    # this use to throw a type error, but I can't think of a reason
    # why converting it for the user would be bad
    if type(value) not in [int, long]:
        if type(value) is str:
            value = long(value,0)
        else:
            value = long(value)
    if type(bitvalue) not in [int, long]:
        if type(bitvalue) is str:
            bitvalue = long(bitvalue,0)
        else:
            bitvalue = long(bitvalue)
    if (upperbit < lowerbit) or (lowerbit < 0):
        raise ValueError('upperbit=%d, lowerbit=%d' % (upperbit, lowerbit))
    mask = int(pow(2, (upperbit - lowerbit + 1)) - 1)
    if bitvalue > mask:
        raise ValueError("Can not set bits to 0x%x b/c max value for bitfield is 0x%x"%(long(bitvalue),mask))
    bitvalue &= mask
    bitvalue <<= lowerbit
    newvalue = value & ~(mask << lowerbit) | bitvalue
    return newvalue

def binstr2num(binstr):
    """
    Takes binary string that is MSB->LSB and returns a number, ex: '0101' returns 0x5
    """
    if sys.version_info[:2]==(2,5):
        newnum = 0
        # put in a direction that's easy to convert, strange enough, there's not a
        # reverse funciton so here's a hack from the net:
        binstr = "".join(reversed(binstr))
        for bitnum in range(len(binstr)):
            if   binstr[bitnum] == '0': bitval = 0
            elif binstr[bitnum] == '1': bitval = 1
            else: raise Exception("Invalid value for binary: %s"%binstr[bitnum])
            newnum |= bitval<<bitnum
        return newnum
    else:
        return int(binstr,2)

def getindices(value):
    """Returns an array of indices where the indices represent bits in the
    value that are set to 1. This is generally useful for registers where
    the fields are only 1 bit wide."""
    setbits = []
    if value != 0:
        for i in range(int(math.log(value,2))+1):
            if (value >> i) & 1:
                setbits.append(i)
    return setbits

def num_to_buffer(value, numbits):
    """
    Args:
        value: Python long/int to convert to a byte array
        numbits:

    Returns:

    """
    if numbits > 64:
        byteArrayData = "%x" % value
        hexStringLength = len(byteArrayData)
        byteLength = int(numbits / 8) + int(numbits % 8 != 0)
        expectedStringLength = byteLength * 2
        if hexStringLength < expectedStringLength:
            padding = expectedStringLength - hexStringLength
            byteArrayData = "0" * padding + byteArrayData
        elif hexStringLength > expectedStringLength:
            raise ValueError("value is %s bits which is greater than numbits=%s" % (value.bit_length(), numbits))
        byteArrayData = bytearray(binascii.unhexlify(byteArrayData))
        byteArrayData.reverse()
        return (ctypes.c_ubyte*byteLength).from_buffer(byteArrayData)
    elif numbits > 32:  # <= 64
        numbytes = 8
        data = ctypes.create_string_buffer(numbytes)
        struct.pack_into('<Q', data, 0, value)
        return (ctypes.c_ubyte*numbytes).from_buffer(data)
    elif numbits > 16:  # <=32
        numbytes = 4
        data = ctypes.create_string_buffer(numbytes)
        struct.pack_into('<I',data, 0, value)
        return (ctypes.c_ubyte*numbytes).from_buffer(data)
    elif numbits > 8:  # <=16
        numbytes = 2
        data = ctypes.create_string_buffer(numbytes)
        struct.pack_into('<H', data, 0, value)
        return (ctypes.c_ubyte*numbytes).from_buffer(data)
    else:  # <= 8
        numbytes = 1
        return (ctypes.c_ubyte*numbytes)(value)


def buffer_to_num(data):
    """takes a list of bytes and returns a python long

    Args:
        data : must be a buffer that struct can work on
    """
    dlen = len(data)
    if dlen == 0:
        return 0  # ? or throw exception
    if dlen == 1:
        return struct.unpack('<B', data)[0]
    elif dlen == 2:
        return struct.unpack('<H', data)[0]
    elif dlen == 4:
        return struct.unpack('<I', data)[0]
    elif dlen == 8:
        return struct.unpack('<Q', data)[0]
    else:
        byteArrayData = bytearray(data)
        byteArrayData.reverse()
        return int(binascii.hexlify(byteArrayData), 16)