from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import sys
PY2 = sys.version_info[0] == 2
# support for old 2.x base classes class
if not PY2:
    basestring = str
    long = int
    buffer = memoryview
    xrange = range
else:
    # must be 2.x
    input = raw_input
 
def with_metaclass(meta_class):
    def class_decorator(cls):
        class_info = vars(cls).copy()
        class_info.pop('__dict__', None)
        class_info.pop('__weakref__', None)
        return meta_class(cls.__name__, cls.__bases__, class_info)
    return class_decorator