import re
from namednodes import settings

def _atoi(text):
    return int(text) if text.isdigit() else text

def _natural_keys(node):
    '''
    alist.sort(key=natural_keys) sorts in human order
    http://nedbatchelder.com/blog/200712/human_sorting.html
    (See Toothy's implementation in the comments)
    '''
    sort_by =settings.DISPLAY_SHOW_COMP_SORT
    text=getattr(node, sort_by)
    return [ _atoi(c) for c in re.split(r'(\d+)', text) ]
