
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ._py2to3 import *

import re
import math

char_backspace = re.compile(".\b")
any_backspace = re.compile("\b+")


def apply_backspaces(s):
    """helper function used to remove backspaces from user input"""
    while 1:
        t = char_backspace.sub("",s)
        if len(s) == len(t):
            return any_backspace.sub("",t)
        s = t
    return

def menu_prompt(choices,**kwargs):
    """prompt user with the specified choices"""
    # this is an override for testing
    choice = kwargs.pop("choice",-1)
    if len(kwargs)>0:
        raise Exception("kwargs not supported: %s"%str(kwargs))
    # number of spaces we need for a bood prompt
    pad = int(math.log10(len(choices))+1)
    menustrs = [ "{0:>{1}}) {2}".format(c+1,pad,choicestr)
                for c,choicestr in enumerate(choices) ]
    menustr = "\n".join(menustrs)
    # loop until we get a valid answer
    while choice == -1:
        print()
        print(menustr)
        print()
        try:
            choice = input("Selection: ")
            choice = apply_backspaces(choice)
            choice = int(choice)
        except KeyboardInterrupt:
            return None
        except:
            print('invalid choice...')
            choice = -1
        else:
            if choice<1 or (choice>(len(choices))):
                print('invalid choice: %s'%choice)
                choice = -1
    return choices[choice-1]
