# INTEL CONFIDENTIAL
# Copyright 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.

from ..precondition import SystemPreconditionGen2 as _SystemPrecondition
try:
    from svtools.common import baseaccess
except ImportError:
    baseaccess = None

# if some new baseaccess comes allong, they can add themselves here
_supports_halt = set(["itpii", "ipc"])

class GpcHaltRequired(_SystemPrecondition):

    @classmethod
    def precondition(cls, node_or_component):
        """Use the common.baseaccess, this will attempt to halt GPC cores if they are running"""
        component = getattr(node_or_component, "component", node_or_component)
        base = baseaccess.getglobalbase()
        if str(baseaccess.getaccess()) in _supports_halt:
            isrunning = base.isrunning()
            cls.put_info(component.origin, "isrunning", isrunning)
            if isrunning:
                base.halt()

    @classmethod
    def postcondition(cls, node_or_component):
        """Use the common.baseaccess, this will return GPC cores to the runstate found by the precondtion"""
        component = getattr(node_or_component, "component", node_or_component)
        base = baseaccess.getglobalbase()
        if str(baseaccess.getaccess()) in _supports_halt:
            was_running = cls.get_info(component.origin, "isrunning")
            if was_running:
                base.go()
