
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.





#########################################
#
# This module is imported by afd/tdef generated access code
#
#########################################
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ..utils._py2to3 import *
from ipccli import BitData
from six import PY2,PY3

if PY2:
    from collections import MutableMapping
if PY3:
    from collections.abc import MutableMapping

# shortcut to help with python running out of memory
BitDataDeposit = BitData.Deposit

import six

class TdefAccessParams(MutableMapping):
    """
    Has all paramters of array info, as well helps to find whether to use stored value
    or current value for the nodes
    """
    def __init__(self,node):
        self.node = node
        self.info = {}
        # always have array info
        self.info.update( node.array_info )
    def __setitem__(self,item,value):
        self.info[item] = value
    def __delitem__(self,item,value):
        raise Exception("not supported for this object")
    def __getitem__(self,item):
        # Check our current known cache first
        info_val = self.info.get(item,None)
        if info_val is not None:
            return info_val
        # ok, we need to do a look up, order of checking is:
        #   - node.target_info
        #   - node.info
        #   - node childrend
        #   - component.target_info
        #   - component.info
        #if item in self.node.nodenames:
        if item in self.node.target_info:
            self.info[item] = self.node.target_info[item]
        elif item in self.node.info:
            self.info[item] = self.node.info[item]
        elif item in self.node.nodenames:
            child_node = self.node.get_node(item)
            # try to used stored value if we have it, otherwise use its current value
            nodeval = child_node.stored_value or long(child_node)
            self.info[item] = nodeval
        elif item in self.node.component.target_info:
            self.info[item] = self.node.component.target_info[item]
        elif item in self.node.component.definition.info:
            self.info[item] = self.node.component.definition.info[item]
        else:
            device = self.node.component.target_info['device']
            if isinstance(device, six.string_types):
                device = baseaccess().devicelist[device]
            self.info[item] = getattr(device, item, None)
            if self.info[item] is None:
                raise ValueError("Could not find parameter: {}".format(item))
        return self.info[item]

    def __iter__(self):
        for i in self.items:
            yield i
        for i in self.node.nodenames:
            yield i

    def __len__(self):
        return len(self.info)


# we have this in case someone would want to override and point back to DAL
def baseaccess():
    import ipccli
    return ipccli.baseaccess()

def device_locker(ipcobj,device=None):
    return ipcobj.device_locker(device=None)


class Jtag(object):

    @classmethod
    def Shift(cls, device, eJtagState, collectTdo, count, data):
        if eJtagState == 'ShfIR':
            # data first, then count
            value = device.node.irscan(data, count)
        elif eJtagState == 'ShfDR':
            # count first, then data
            value = device.node.drscan(count, data)
        else:
            raise Exception("Unexpected jtag state: %s"%eJtagState)
        # return BitData(count, value) # not sure why we were wrapping this with BitData at one time
                                       # it should already be coming back as a bit data object
        return value

    @classmethod
    def GoToState(cls, device, eJtagState, count, eWait):
        if eWait not in [0 , "0"]:
            raise Exception("Missing proper support for eWait...not sure what it is")
        return device.node.jtag_goto_state( eJtagState, count, "COUNT")
        # original
        return device.node.jtag_goto_state( state, clocks, waitType)


class RegBus(object):
    regbus = None

    @classmethod
    def SetRegBus(cls, bus):
        cls.regbus = bus

    @classmethod
    def Write(cls, device, address, data):
        func = getattr(cls, cls.regbus, None)
        if func is None:
            raise ValueError("missing regbus function %s"%cls.regbus)
        return func(device, address, data)

    @classmethod
    def Read(cls, device, address):
        func = getattr(cls, cls.regbus, None)
        if func is None:
            raise ValueError("missing regbus function %s"%cls.regbus)
        return func(device, address )


class StatePort(object):
    @classmethod
    def Read(cls, device, port, address):
        stateport = getattr(device.node.stateport, port)
        return stateport(*address)

    @classmethod
    def Write(cls, device, port,  address, data):
        stateport = getattr(device.node.stateport, port)
        return stateport(*address, newValue=data)


class PreScan(object):
    @classmethod
    def MakeTapAccessible(cls, device):
        """nothing don for this, assumes openipc is doing this"""
        pass

class State(object):
    @classmethod
    def PopContextType(cls, device):
        """unsure what the purpose of this one is"""
        pass
# not listed because these seem to behave less consistent accross projects
