
# INTEL CONFIDENTIAL
# Copyright  2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ..comp import ComponentPlugin
from inspect import getmembers, ismethod
from ..utils._py2to3 import *


class LoadComponentApi(ComponentPlugin):
    """This plugin creates an api object under each component
    and shows the 'callable' methods for that component"""
    name = "api"
    final_function_dict = None
    __no_class_dir__ = True

    def __init__(self, component):
        super(LoadComponentApi, self).__init__(component)

    def _fillit(self):
        """"""
        if self.final_function_dict is None:
            self.final_function_dict={}
            complete_functions_list = self._get_callable_methods()
            for fn, fp in complete_functions_list:
                if fn.startswith("_"):
                    continue
                else:
                    self.final_function_dict[fn] = fp

    def _get_callable_methods(self):
        """"""
        complete_functions_list = None
        if self.component.nodenames:
            dir(self.component)
            component_dict = self.component.__dict__.items()
            for codn, codf in component_dict:
                if codn == "registers" or codn=="subcomponents":
                    import pdb;pdb.set_trace()

            complete_functions_list = [o for o in component_dict if ismethod(o[1])]
        else:
            complete_functions_list = [o for o in getmembers(self.component) if ismethod(o[1])]
        return complete_functions_list

    def show_api(self):
        """
        Returns a list with all the available methods in the component.
        """
        self._fillit()
        return self.final_function_dict.keys()

    def __getattr__(self, attr):
        self._fillit()
        if attr in self.final_function_dict:
            return self.final_function_dict[attr]
        raise AttributeError("Unknown Attribute {}".format(attr))

    def __dir__(self):
        self._fillit()
        dirlist = list(self.__dict__.keys())
        dirlist.extend(dir(self.__class__))
        dirlist.extend(list(self.final_function_dict.keys()))
        # Allow components to hide attributes
        hidden_api_attributes = self.component.definition.info.get("hidden_api_attributes", [])
        if hidden_api_attributes:
            dirlist = list(set(dirlist) - set(hidden_api_attributes))
        return dirlist

