
# INTEL CONFIDENTIAL
# Copyright 2014 2017 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

# requires the walk plugins
from . import nn_walk
from ..comp import ComponentDefinitionPlugin
from ..utils._py2to3 import *


_OSX_MAP_KEY = "osx_address_maps"


class CreateComponentTreePlugin(ComponentDefinitionPlugin):
    name = "create_tree"

    def __call__(self, name=None, skip=None):
        """
        Create a tree of Component's that mimic the ComponentDefinition's
        and their sub_components the same name of the component definitions
        will be used for the Component objects

        Args:
            name (str) : name to use for the top level of the tree instead of the of
                         the definition's name
            skip (list) : list of sub components to skip when creating the tree
                          of sub-components
        """
        parent_def = self.definition
        name = name or parent_def.name
        # if osx_address_map start, there instead of here...
        if _OSX_MAP_KEY in self.definition.info:
            return self.definition.create_tree_osr(name, skip)

        top_level = parent_comp = parent_def.create(name=name)
        skip = set() if skip is None else set(skip)

        # keep up with previous component value objects based on component
        # definition paths
        # key = compdef.path, value = comp value object
        def create_sub_components(comptarget, compdef, skip=set()):
            for sub_comp in compdef.sub_components.values():
                if sub_comp.name in skip:
                    continue
                if _OSX_MAP_KEY in sub_comp.info:
                    next_comp = sub_comp.create_tree_osr()
                    if isinstance(next_comp, list):
                        for c in next_comp:
                            comptarget.add_component(c, skip_sort=True)
                    else:
                        comptarget.add_component(next_comp, skip_sort=True)
                elif 'nn_number_of_instances' in sub_comp.info and sub_comp.name("{"):
                    # needs filled in from old code flow
                    pass
                else:
                    next_comp = sub_comp.create(sub_comp.name)
                    comptarget.add_component(next_comp, skip_sort=True)
                    create_sub_components(next_comp, sub_comp)
            # now sort at this level
            comptarget.sort_component_groups()

        create_sub_components(top_level, parent_def, skip=skip)
        return top_level


class CreateComponentTreePluginOsr(ComponentDefinitionPlugin):
    name = "create_tree_osr"

    def __call__(self, name=None, skip=None, **kwargs):
        """
        Create a tree of Component's that mimic the ComponentDefinition's
        and their sub_components the same name of the component definitions
        will be used for the Component objects

        Args:
            name (str) : name to use for the top level of the tree instead of the of
                         the definition's name
            skip (list) : list of sub components to skip when creating the tree
                          of sub-components
        """
        # if this is False, it means it is ok to return a list instead of single component
        create_container = kwargs.pop("create_container", True)
        if len(kwargs) > 0:
            raise ValueError("Uknown kwargs: %s"%list(kwargs))
        # check top level, if no osx_address_map send back to create tree
        osx_address_maps = self.definition.info.get(_OSX_MAP_KEY, None)
        if osx_address_maps is None:
            return self.definition.create_tree(name, skip)
        # this means that we definitel have an osx_address_map
        parent_def = self.definition
        name = name or parent_def.name
        skip = set() if skip is None else set(skip)
        comp_list = []
        map_type = osx_address_maps.get('type', None)
        if map_type is None:
            raise ValueError(
                "this database was generated with an older svtools.onesource and it is no longer supported")

        if map_type == "map":
            # simplest case, just copy to target info and we are done
            nodename = parent_def.name
            nncomponent = parent_def.create(nodename)
            nncomponent.target_info[_OSX_MAP_KEY] = osx_address_maps

        elif map_type == "component":
            # this shouldn't happen since the osr generator tries to push component maps down closer to the
            # actual component in this scenario...
            nodename = parent_def.name
            nncomponent = parent_def.create(nodename)
            # print("possible collateral issue with {}".format(parent_def.path))
            nncomponent.target_info[_OSX_MAP_KEY] = osx_address_maps
            # yes, this is very similar to array, but just different enough to be a pain
            # on consolidated the code, not 100% sure if we are hitting this case...
            self.sub_component_handling(nncomponent, parent_def.sub_components, osx_address_maps)

        elif map_type == "array":
            # must be array or components...
            for ins_n in osx_address_maps:
                if ins_n == "type":
                    continue
                if not isinstance(ins_n, int):
                    raise RuntimeError("non instance value {} found in the array".format(ins_n))

                nodename = parent_def.name + "{instance}".format(instance=ins_n)
                address_map = osx_address_maps[ins_n]
                nncomponent = parent_def.create(nodename)
                nncomponent.target_info[_OSX_MAP_KEY] = address_map
                comp_list.append(nncomponent)
                if parent_def.sub_components:
                    self.sub_component_handling(nncomponent,
                                                parent_def.sub_components,
                                                address_map)
                nncomponent.sort_component_groups()
        if comp_list:
            return comp_list
        else:
            return nncomponent

    def sub_component_handling(self, nncomponent, subcomponents, address_map_dict):
        for subc, subcomp in subcomponents.items():
            address_map = address_map_dict.get(subc, None)
            if address_map:
                curr_dict_keys = address_map.keys()
                for ins_n in curr_dict_keys:
                    if ins_n == "type":
                        continue
                    if isinstance(ins_n, int):
                        nodename = subcomp.name + "{instance}".format(instance=ins_n)
                        n_address_map = address_map[ins_n]
                    else:
                        nodename = subcomp.name
                        n_address_map = address_map
                    nn_component = subcomp.create(nodename)
                    nncomponent.add_component(nn_component, skip_sort=True)
                    if _OSX_MAP_KEY not in nn_component.target_info:
                        nn_component.target_info[_OSX_MAP_KEY] = {}
                    nn_component.target_info[_OSX_MAP_KEY] = n_address_map
                    if subcomp.sub_components:
                        self.sub_component_handling(nn_component,
                                                    subcomp.sub_components,
                                                    n_address_map)
                    # only do this once if we are not in integers and handling the logical maps...
                    if not isinstance(ins_n, int):
                        break
            else:
                # no address map, default back to create_tree
                nncomponent.add_component(subcomp.create_tree())

                # done with this level sort our groups
        nncomponent.sort_component_groups()
