

# Copyright 2014 2017 Intel Corporation.
#
# The source code,  information  and material  ("Material") contained herein is
# owned  by  Intel Corporation or its suppliers or licensors, and title to such
# Material remains  with Intel  Corporation or its  suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors.
# The  Material is  protected by  worldwide copyright laws and treaty provisions.
# No part  of the Material may  be used, copied, reproduced, modified, published,
# uploaded, posted,  transmitted,  distributed  or  disclosed in any way without
# Intel's prior express written permission.
# No license under any patent, copyright  or  other intellectual property rights
# in  the  Material is  granted to  or conferred  upon you, either expressly, by
# implication, inducement, estoppel or otherwise.
# Any  license under such  intellectual  property  rights  must  be  express and
# approved by Intel in writing.



"""
This example shows how to make use of the Static XML example that built a
component.
"""


from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import namednodes
from namednodes import settings
from namednodes.comp import CreateComponentDefinitionAlias
from namednodes.plugins import nn_display, nn_logregisters
from namednodes.registers import RegisterComponent
from namednodes.utils._py2to3 import *

if PY2:
    from cStringIO import StringIO
else:
    from io import StringIO

def main():
    settings.PROJECT = "ExampleProj"
    namednodes.sv.initialize()
    sockets = namednodes.sv.socket.get_all(stop_on_error=True)

    print('sockets: '        , sockets)
    print('socket0.parent: '        ,sockets[0].parent)
    print('socket0.origin: '        ,sockets[0].origin)
    print('sockets[0].namednodes: '      ,sockets[0].nodenames)
    print('sockets[0].core0.thread0.parent: ', sockets[0].core0.thread0.parent.name)
    print('sockets[0].core0.thread0.origin: ', sockets[0].core0.thread0.origin.name)
    print('sockets[0].core0.thread0.nodenames: ', sockets[0].core0.thread0.nodenames)
    print('sockets[0].core0.thread0.ia32_mcg_cap: ', sockets[0].core0.thread0.ia32_mcg_cap)
    print('sockets[0].uncore.voltage: ', sockets[0].uncore.voltage)
    print ("---show----")
    sockets[0].core0.thread0.ia32_mcg_cap.show()
    print ("------------")
    print('sockets[0].uncore_uarch.cache: ', sockets[0].uncore_uarch.cache)
    assert sockets[0].uncore_uarch.cache.set[1].way[1].data == 0x11
    print ("------------")

    ###### ENUM Examples
    print("----- Enum Examples ----- ")
    # show enum values and encode/decode for complex functions
    print('sockets[0].uncore.pcie_header.count: {} - {}'.format(
          sockets[0].uncore.pcie_header.count,
          sockets[0].uncore.pcie_header.count.decode()
          ))
    # NOTE: we use encode here, not just a write
    sockets[0].uncore.pcie_header.count.encode(40)
    print("sockets[0].uncore.pcie_header.count.encode(40)")
    print('sockets[0].uncore.pcie_headers.count: {} - {}'.format(
          sockets[0].uncore.pcie_header.count,
          sockets[0].uncore.pcie_header.count.decode()
          ))

    # show enum values and encode/decode for simple decodes
    print('sockets[0].uncore.pcie_header.lookup: {} - {}'.format(
          sockets[0].uncore.pcie_header.lookup,
          sockets[0].uncore.pcie_header.lookup.decode()
          ))
    # NOTE: we use encode here, not just a write
    sockets[0].uncore.pcie_header.lookup.encode("bar")
    print('sockets[0].uncore.pcie_header.lookup.encode("bar")')
    print('sockets[0].uncore.pcie_headers.lookup: {} - {}'.format(
          sockets[0].uncore.pcie_header.lookup,
          sockets[0].uncore.pcie_header.lookup.decode()
          ))
    ###### End ENUM Examples

    ## node grouping in the same component ##
    # create node groups
    print ("--- show registers in the register group ----")
    print('Create group using: sockets[0].uncore.groups.make_register_groups()')
    sockets[0].uncore.groups.make_register_groups()
    print('sockets[0].uncore.groups.vmdX_pmsixdata')
    print(sockets[0].uncore.groups.vmdX_pmsixdata)
    print ("------------")

    ## work with an alias component to group registers from different components ##
    # create alias component definition object
    thread_mcg_cap = CreateComponentDefinitionAlias(
                        "thread_mcg_cap",
                        RegisterComponent)

    # we require the node value objects to populate the definition
    # object of the alias component
    for core in sockets[0].cores:
        for thread in core.threads:
            # get value object for the current node
            reg_value = thread.get_node("ia32_mcg_cap")
            # add node value to alias component definition
            # it is allowed to rename the register if required
            thread_mcg_cap.add_node(
                    reg_value,
                    reg_value.name+'_'+core.name+'_'+thread.name
            )
    # add alias component value object as a subcomponent
    sockets[0].add_component(thread_mcg_cap.create("threads_mcg_caps"))
    log_registers = StringIO()
    print("sockets[0].threads_mcg_caps.logregisters(log_file)")
    sockets[0].threads_mcg_caps.logregisters(log_registers)
    print(log_registers.getvalue())
    return sockets

# used by the testing code to run whatever examples are in this file
def run_examples():
    main()

if __name__ == "__main__":
    try:
        from svtools.common import baseaccess
        baseaccess.setaccess("stub")
    except ImportError:
        pass
    sockets = main()
    sv = namednodes.sv
