
# Copyright 2014 2017 Intel Corporation.
#
# The source code,  information  and material  ("Material") contained herein is
# owned  by  Intel Corporation or its suppliers or licensors, and title to such
# Material remains  with Intel  Corporation or its  suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors.
# The  Material is  protected by  worldwide copyright laws and treaty provisions.
# No part  of the Material may  be used, copied, reproduced, modified, published,
# uploaded, posted,  transmitted,  distributed  or  disclosed in any way without
# Intel's prior express written permission.
# No license under any patent, copyright  or  other intellectual property rights
# in  the  Material is  granted to  or conferred  upon you, either expressly, by
# implication, inducement, estoppel or otherwise.
# Any  license under such  intellectual  property  rights  must  be  express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import os
from . import example_builder
import namednodes.discovery
from namednodes.discoveries.static import StaticDiscovery, add_access_without_value

# so these are needed here even though they are not used, because our generated component needs them
from namednodes.accesses import general as _general
from namednodes.accesses.state import StateNodeBase

###############################################################################
# build an access for demonstrating the reading of an array
###############################################################################
class AccessSetWay(StateNodeBase):
    @classmethod
    def read(cls, node):
        set = node.array_info['set']
        way = node.array_info['way']
        return (set<<0x4) | way

########################################
# Create our example project's discovery
########################################
class ExampleSocketDiscovery(namednodes.discovery.Discovery):
    def __init__(self):
        ########################################
        # ALWAYS call the parent class's constructor
        ########################################
        super(ExampleSocketDiscovery,self).__init__()
        #################################################################
        # Discovery's can use other discoveries as well.
        # here we will leverage the static discovery
        ################################################################
        static_path = example_builder.get_out_path( example_builder._static_out_file)
        lmdb_path = example_builder.get_out_path( example_builder._LMDB_FILE)
        self.static = StaticDiscovery(static_path, lmdb_path)
        self.static.share_items( self )
        # even if we are in offline mode, don't overwrite our set/way example
        # acccess. It is extremely rare that you will need to set this
        add_access_without_value(AccessSetWay)

    def find_all(self):
        # we are overriding the typical find-all, so no need to call parent
        # class's findall like we have to with the init
        # if we are in stub mode, then we would tell the static
        # discovery to work in offline mode. In our particular example it won't
        # matter
        ##if baseaccess.getaccess()=="stub":
        #    self.static.offline=True
        #else:
        #    self.static.offline=False
        #############################################################
        # Return whatever the static discovery found in this example
        #############################################################
        return self.static.find_all()

def init():
    # make sure we are operating in stub mode
    # register our discovery class
    namednodes.discovery.register("socket",ExampleSocketDiscovery())

