
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.




"""
Module implementing accesses events functionality.
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ._manager import EventManager, Event
from ..utils._py2to3 import *

# initialize QueuingEventManager
QueuingEventManager = EventManager()

# Wrappers for hiding event manager from users.
subscribe = QueuingEventManager.subscribe
unsubscribe = QueuingEventManager.unsubscribe
send_event = QueuingEventManager.send_event


class _QueuingEvent(Event):
    """
    Base class for queuing event objects.
    """
    def __init__(self, event_data=None):
        Event.__init__(self, self.__class__, self.__class__.__name__)

        # Generic container for any data that might be included with an event
        self._event_data = event_data

    @property
    def event_data(self):
        return self._event_data


class QueuingEventTypes(object):
    """ Container for different queuing event types. """

    class create(_QueuingEvent):
        """ Event which is triggered when queue object is created """

    class enter(_QueuingEvent):
        """ Event which is triggered upon block enter """

    class exit(_QueuingEvent):
        """ Event which is triggered upon block exit """

    event_types = [create, enter, exit]
