
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.
"""

.. autoclass:: VersionError
.. autoclass:: PluginError
.. autoclass:: StaticDiscoveryError
.. autoclass:: DeviceNotFound
.. autoclass:: OfflineMissingNode
.. autoclass:: SnapshotOverride
.. autoclass:: OsxError

"""



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

#############################################
# For holding all the known error conditions
#############################################

class VersionError(Exception):
    pass

class PluginError(Exception):
    pass

class StaticDiscoveryError(Exception):
    pass

class DeviceNotFound(Exception):
    pass

class OfflineMissingNode(Exception):
    def __init__(self, msg, node_path):
        # node object (?)
        self.msg = msg
        self.node_path = node_path
    def __str__(self):
        return "OfflineMissingNode: %s"%(self.msg)


class SnapshotOverride(Exception):
    """Thrown when you try to write to register during a snapshot override"""
    pass


class OsxError(Exception):
    """Thrown when an OSX informatin is missing from the default/expected flow"""
    pass

