
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from . import static as _static
import os

# these are unused imports, but for offline mode we are going to direct folks in the
# help files to use this file vs. the static file
from .static import load_offline as load
from .static import write_values

class OfflineDiscovery(_static.StaticDiscovery):
    def __init__(self, filename=None, offline_dir=None):
        """
        Discovery class that can be used to load components from a file, and the named
        accesses will be directed to offline storage

        Args:
            filename (str) : filename that we should load from (it should reside in offline_dir)
            offline_dir (str) : directory to look at when loading or saving offline files

        """
        super(OfflineDiscovery, self).__init__(filename, None, offline_dir, offline=True)

    @property
    def filename(self):
        return self.static_filename

    @filename.setter
    def filename(self, value):
        self.static_filename = value

    @property
    def filepath(self):
        """full path of filname + offline_dir (if offline dir is set)"""
        if self.offline_dir is not None:
            fulllpath = os.path.join(self.offline_dir, self.filename)
        else:
            fullpath = self.filename
        return fullpath

    def save_all(self, filename=None, **kwargs):
        """
        Reads all available registers and saves their values. Not just the discovery and
        already known values

        Args:
            filename (str) : filename to save them (which will be  combined with the current
                             offline_dir to create a path)
            comp_paths : optional list of paths to use for saving only some values instead
                         of all values
            raise_exceptions : to stop on first error when saving

        By default saves to whatever file we loaded our discovery from

        Returns:
            None
        """
        comps = self.get_all()
        # if the comps were already offline, then
        # just update their static self.
        if filename is None:
            filename = self.filepath
        else:
            filename = os.path.join(self.offline_dir, filename)
        _static.write_values(comps, filename, **kwargs)


