
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import logging
from .logging import getLogger
from . import settings

_log = getLogger()


def show_plugins():
    from .nodes import NodeValuePlugins
    from .comp import ComponentPluginManager,ComponentLoaderPluginManager

    """Function for showing all the registered plugins"""
    _log.result("Discovery")

    _log.result("-"*70)
    _log.result("Component")
    for name,plugin in ComponentPluginManager.plugins.items():
        _log.result("{0} = {1}".format(name,plugin))
    
    _log.result("-"*70)
    _log.result("ComponentLoader")
    for name,plugin in ComponentLoaderPluginManager.plugins.items():
        _log.result("{0} = {1}".format(name,plugin))

    _log.result("-"*70)
    _log.result("NodeValue")
    for name,plugin in NodeValuePlugins.plugins.items():
        _log.result("{0} = {1}".format(name,plugin))


def log_all_to_screen():
    """
    log multiple access to file
    this is not ready or meant for parsing
    """
    settings.DEBUG = True
    cli_logging.getManager().echo(True) # enable messages to the screen
    _log.setLevel("DEBUGALL")
    #_log.addFilter( NoAccess() )

###########################################################
# class used simply to organize our filters
# !!!!!!!! NOT for general usage yet, the name/organization of this is subject to chain
###########################################################
class _LogFilters:
    class NoAccess(logging.Filter):
        """Filters out access calls"""
        def filter(self,record):
            text = record.getMessage()
            if text.startswith(("get_access_method",
                                "get_access_class",
                                )):
                return False
            else:
                return True

    class NoCaller(logging.Filter):
        """Filters out access calls"""
        def filter(self,record):
            text = record.getMessage()
            if text.startswith(("CALLER",
                                )):
                return False
            else:
                return True

