
# INTEL CONFIDENTIAL
# Copyright 2014 2018 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.




from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from ..comp import NamedComponent, ComponentGroup
from ..registers import RegisterComponent
try:
    from svtools.common import baseaccess
except:
    baseaccess = None

class SocketComponent(RegisterComponent):

    @property
    def _socketNum(self):
        """returns targetinfo['socket_num']"""
        print("switch to using target_info['socketNum']")
        return self.target_info['socket_num']

class CpuComponent(RegisterComponent):
    """For the socket.cpu component so that we always have
    containers for modules/cores/threads that include all the children

    This assumes that the component values follow the pattern of:

        socket#.cpu.module#.core#.thread#

    And that this is the socket.cpu object
    """
    @property
    def modules(self):
        if "modules" in self._sub_groups:
            return self._sub_groups['modules']
        else:
            return ComponentGroup([],"modules", self.path+".modules")

    @property
    def cores(self):
        "" ""
        # this shouldn't happen if adhering to expected flow, but just in case
        if "cores" in self._sub_groups:
            return self._sub_groups['cores']
        # on to expected flow of have cpu.modules.cores.threads
        modules = self.modules
        if len(modules) == 0:
            return ComponentGroup([],"cores", self.path+".cores")
        # this is broken out vs. combining in previous in case of performance
        cores = getattr(modules,"cores", None)
        if cores is None:
            return ComponentGroup([],"cores", self.path+".cores")
        # we must have found some cores
        return cores

    @property
    def threads(self):
        # this shouldn't happen if adhering to expected flow, but just in case
        if "threads" in self._sub_groups:
            return self._sub_groups['threads']
        # on to expected flow of have cpu.modules.cores.threads
        cores = self.cores
        if len(cores) == 0 or getattr(cores,"threads",None) is None:
            return ComponentGroup([],"threads", self.path+".threads")
        # this is broken out vs. combining in previous in case of performance
        threads = getattr(cores,"threads", None)
        if threads is None:
            return ComponentGroup([],"threads", self.path+".threads")
        # we must have found some cores
        return threads

class ModuleComponent(RegisterComponent):
    """To make sure mocules always have cores and threads containers
    """
    @property
    def cores(self):
        ""
        # this shouldn't happen if adhering to expected flow, but just in case
        if "cores" in self._sub_groups:
            return self._sub_groups['cores']
        else:
            return ComponentGroup([],"cores", self.path+".cores")

    @property
    def threads(self):
        # this shouldn't happen if adhering to expected flow, but just in case
        if "threads" in self._sub_groups:
            return self._sub_groups['threads']
        # on to expected flow of have cpu.modules.cores.threads
        cores = self.cores
        if len(cores) == 0 or getattr(cores,"threads",None) is None:
            return ComponentGroup([],"threads", self.path+".threads")
        # this is broken out vs. combining in previous in case of performance
        threads = getattr(cores,"threads", None)
        if threads is None:
            return ComponentGroup([],"threads", self.path+".threads")
        # we must have found some cores
        return threads


class CoreComponent(RegisterComponent):
    """
    To make sure cores always have a threads container
    """
    @property
    def threads(self):
        ""
        # this shouldn't happen if adhering to expected flow, but just in case
        if "threads" in self._sub_groups:
            return self._sub_groups['threads']
        else:
            return ComponentGroup([],"threads", self.path+".threads")


# not really needed but in case we add some future functionality common to
# all threads like we did for the rest of the cpu related components
class ThreadComponent(RegisterComponent):
    def msr(self, addr, data=None):
        """
        Reads the specified MSR on this thread

        Args:
            addr: msr addresss
            data: data to write, or None to do a read

        Returns:
            data read from the msr
        """
        assert baseaccess is not None, "pythonsv-common must be installed for this access to work"
        base = baseaccess.getglobalbase()
        msr_did = self.target_info.get('msr_did', None)
        if msr_did is None:
            msr_did = self.target_info.get('did', None)
        return base.msr(addr, data, msr_did)
