# INTEL CONFIDENTIAL
# Copyright 2014 2017 Intel Corporation
#
# The source code  contained or  described herein and  all documents related to
# the source code  ("Material") are owned by Intel Corporation or its suppliers
# or licensors.  Title to the  Material  remains with  Intel Corporation or its
# suppliers  and licensors. The Material contains trade secrets and proprietary
# and  confidential  information  of  Intel  or  its  suppliers  and  licensors.
# The Material  is protected  by worldwide  copyright and trade secret laws and
# treaty provisions.  No part of the Material  may  be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intel's prior express written permission. No license under
# any  patent,  copyright, trade secret or other intellectual property right is
# granted  to  or conferred upon you by disclosure or delivery of the Materials,
# either expressly, by implication, inducement, estoppel or otherwise.
# Any license under such intellectual property rights must be express and
# approved by Intel in writing.



from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

try:
    from svtools.intel_version import IntelVersion
except ImportError:
    # fallback to LooseVersion in case IntelVersion is not yet installed
    from distutils.version import LooseVersion
    IntelVersion = LooseVersion
    IntelVersion.get_full_version = LooseVersion.__str__


__prerelease__ = ""
__classification__ = 200 
__version__ = IntelVersion("2.10.5" + "." + str(__classification__) + __prerelease__)



"""
for reference from IntelVersion:

Format
===========================================
major.minor[.patch][.classification][prerelease]

Where:

    - major, minor and patch are decimal numbers.
    - if patch is omitted, it will default to 0.
    - classification is limited to 600, 400 or 100.
    - if classification is omitted, it will default to 600 (RED).
    - prerelease consists of the letter 'a' or 'b' followed by a decimal
      number. If the numeric components of two version numbers are equal,
      then one with a prerelease tag will always be deemed earlier (lesser)
      than one without.

Valid Examples
-------------------------------------------
The following are valid version numbers (shown in the order that would be
obtained by sorting according to the supplied cmp function):

=============  ============  ===============
Input string   str()         .pip_version
=============  ============  ===============
0.4            0.4.0         0.4.0.600
0.4.1.100      0.4.1         0.4.1.100
0.4.2          0.4.2         0.4.2.600
0.5a1          0.5.0a1       0.5.0.600a1
0.5b3          0.5.0b3       0.5.0.600b3
0.5            0.5.0         0.5.0.600
0.5.100b3      0.5.100b3     0.5.100.600b3
0.9.6          0.9.6         0.9.6.600
1.0            1.0.0         1.0.0.600
1.0.4a3        1.0.4a3       1.0.4.600a3
1.0.4b1        1.0.4b1       1.0.4.600b1
1.0.5.400b1    1.0.5b1       1.0.5.400b1
1.0.5.100      1.0.5         1.0.5.100
1.0.6          1.0.6         1.0.6.600
=============  ============  ============

Invalid Examples
-------------------------------------------
The following are examples of invalid version numbers:

=============  ============
Input string   Result
=============  ============
1              ValueError
2.7.2.2        ValueError
1.3.a4         ValueError
1.3pl1         ValueError
1.3c4          ValueError
=============  ============
"""
