###############################################################################
# Copyright 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
# intellectual property rights must be express and approved by Intel in writing.
#
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################


import logging
import py2ipc


def LoggingPresetNames():
    gen = py2ipc.IPC_GetService("General")
    return gen.GetLoggingPresetNames()

def GetLoadedLoggingPreset():
    gen = py2ipc.IPC_GetService("General")
    return gen.GetLoadedLoggingPreset()

def WriteLogMessage(message):
    gen = py2ipc.IPC_GetService("General")
    return gen.WriteLogMessage(message)

def LoadLoggingPreset(presetname):
    gen = py2ipc.IPC_GetService("General")
    return gen.LoadLoggingPreset(presetname)

def FlushLogs():
    gen = py2ipc.IPC_GetService("General")
    return gen.FlushLogs()

def ClearLogs():
    gen = py2ipc.IPC_GetService("General")
    return gen.ClearLogs()
    
def ArchiveLogs():
    gen = py2ipc.IPC_GetService("General")
    return gen.ArchiveLogs()
    
class OpenIpcHandler(logging.Handler):
    def __init__(self, manager):
        self._manager = manager
        logging.Handler.__init__(self)
    
    def emit(self, record):
        self._manager.openipc_writemessage(record.getMessage())

def _openipc_echo(self, echoOn=None):
    """Enable logging debug information to the OpenIPC log file
    (you must use level() to set which loggers are enabled for debug)
    """
    if not hasattr(self, "_openipc_handler"):        
        self._openipc_handler = OpenIpcHandler(self)
    if echoOn==None:
        return self._openipc_handler in self._root_logger.handlers
    if echoOn not in [0,1,True,False]:
        raise ValueError("Must specify boolean, (True or False, but not as a string) for echoOn")
    if echoOn:        
        self._root_logger.addHandler(self._openipc_handler)
    else:
        self._root_logger.removeHandler(self._openipc_handler)
