###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter 
# this notice or any other notice embedded in Materials by Intel or Intel's 
# suppliers or licensors in any way.
###############################################################################

import os,sys
from ._py2to3 import *
if PY2:
    import imp
else:
    import importlib as imp

from . import cli_logging
_log = cli_logging.getLogger("itpii_import_hook")
# for debug:
#cli_logging._logmanager.echo(True)
#cli_logging._logmanager.level("itpii_import_hook","DEBUGALL")

_packagename = 'ipccli'

# set during install
_installed = False
_base_dir = None

class ItpsimImport(object):
    def find_module(self, module_name, package_path=""):
        if not module_name.startswith("itpii"):
            return None
        _log.debugall("ENTER: find_module")
        old_modulename = module_name
        # replace the first itpii with itpsim 
        module_name = _packagename+module_name[len("itpii"):]
        _log.debugall("find_module: {0} changed to {1}".format(old_modulename,module_name))
        # ok, we need to load the appropriate module
        components = module_name.split(".")
        subname = components.pop()
        relative_dir = "/".join(components) # path to look for in our package dir
        itpsim_path = os.path.join( _base_dir, relative_dir )
        _log.debugall("find_module: (subname, itpsim_path) , ({0},{1})".format(subname,itpsim_path) )
        try:
            file,filename,stuff = imp.find_module(subname,[itpsim_path])
        except ImportError:
            # file not found, we can't handle this import
            # even though we get here it is difficult to tell if 'itpii' really had
            # it...this is because of absolute import in python27...if 'itpii' imports
            # array, then it comes here looking like 'itpii.array', which is definitely
            # not for us but there's not really an itpii/array.py file either...
            # so we can-not print a reliable warning without a LOT more checks
            _log.debugall("find_module: EXIT, import error, file not found, not handling this import")
            return None

        _log.debugall("find_module: EXIT, calling our ItpsimLoader")
        return ItpsimLoader(file,filename,stuff)

class ItpsimLoader(object):
    def __init__(self,file,filename,stuff):
        self.file = file
        self.filename = filename
        self.stuff = stuff
    def load_module(self,fullname):
        _log.debugall("ENTER: load_module")
        # can't we assume we have "itpii." if we get here?s
        newname = fullname.replace("itpii.",_packagename+".")
        if newname in sys.modules:
            sys.modules[fullname] = sys.modules[newname]
            _log.debugall("load_module: found {0} already imported, returning that instead of {1}".format(newname,fullname))
            _log.debugall("EXIT: load_module")
            return sys.modules[newname]
        #if module_name in sys.modules:
        #    return sys.modules[module_name]
        _log.debugall("load_module: {0} not imported yet, importing and setting {1} to point to it".format(newname,fullname) )
        mod = imp.load_module(newname,self.file,self.filename,self.stuff)
        sys.modules[newname] = mod
        _log.debugall("EXIT: load_module")
        return mod

def install():
    global _installed 
    global _base_dir
    _base_dir = os.path.dirname(__file__)
    if _base_dir=="":
        _base_dir = os.getcwd()
    _base_dir = os.path.normpath( _base_dir + os.sep + "..")

    if _installed==False:
        sys.meta_path.append( ItpsimImport() )
        _installed=True
    # short cut the itpii so that we don't re-load itpsim on accident
    sys.modules['itpii'] = sys.modules[_packagename]
