###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################

''' In IPython 5 there is a bug where getpass.getpass() will echo the password typed.
    This module allows a user to fix this by wrapping getpass() within a script that corrects the issue.

    IPython 3 does NOT have this bug.
    IPython 4 MIGHT have the bug.
    IPython 5 HAS the bug.
    IPython 6 does NOT have this bug, but it only supported on Python 3.
'''
from __future__ import absolute_import

import sys
import getpass as getpass_orig

def getpass(prompt='Password: ', stream=None):
    if ("IPython" not in sys.modules) or (sys.modules["IPython"].version_info[0] not in [4, 5]):
        return getpass_orig.getpass(prompt, stream)
    else:
        return ipython5_getpass(prompt, stream)

def ipython5_getpass(prompt='Password: ', stream=None):
    stdin = sys.stdin
    sys.stdin = sys.__stdin__
    try:
        return getpass_orig.getpass(prompt, stream)
    finally:
        sys.stdin = stdin

