###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter 
# this notice or any other notice embedded in Materials by Intel or Intel's 
# suppliers or licensors in any way.
###############################################################################


from .bitdata import BitData


###############################################################################
# PUBLIC DEFINITIONS
###############################################################################
# These are the definitions (functions/classes/global variables) that are to be
# visible and used outside of this module. The convention is to use names that
# do not have any leading underscores.
try:
    # to assist with some efforts that cannot import ctypes
    import ctypes as _ctypes
    Byref = _ctypes.byref
except ImportError:
    Byref = None

class Ord1(BitData):
    def __init__(self, value = 0x0):
        super(Ord1, self).__init__(8, value)

class Ord2(BitData):
    def __init__(self, value = 0x0):
        super(Ord2, self).__init__(8*2, value)
        
class Ord4(BitData):
    def __init__(self, value = 0x0):
        super(Ord4, self).__init__(8*4, value)
        
class Ord8(BitData):
    def __init__(self, value = 0x0):
        super(Ord8, self).__init__(8*8, value)


class UserType(object):
    """This object memics any data type, but the inheriting class needs to define
     the datatype
     """
    _usertype = None
    def __init__(self): raise Exception("This is a virtual class")
    def __long__(self): return self._usertype(self).__long__()
    def __int__(self): return self._usertype(self).__int__()
    def __abs__(self): return self._usertype(self).__abs__()
    def __add__(self,other): return self._usertype(self).__add__(self._usertype(other))
    def __and__(self,other): return self._usertype(self).__and__(self._usertype(other))
    def __cmp__(self,other): return self._usertype(self).__cmp__(self._usertype(other))
    def __coerce__(self,other): return self._usertype(self).__coerce__(other)
    def __div__(self,other): return self._usertype(self).__div__(self._usertype(other))
    def __divmod__(self,other): return self._usertype(self).__divmod__(self._usertype(other))
    def __float__(self): return self._usertype(self).__float__()
    def __floordiv__(self,other): return self._usertype(self).__floordiv__(self._usertype(other))
    def __hex__(self): return self._usertype(self).__hex__()
    def __invert__(self): return self._usertype(self).__invert__()
    def __complex__(self): return self._usertype(self).__complex__()
    def __lshift__(self,other): return self._usertype(self).__lshift__(self._usertype(other))
    def __mod__(self,other): return self._usertype(self).__mod__(self._usertype(other))
    def __mul__(self,other): return self._usertype(self).__mul__(self._usertype(other))
    def __neg__(self): return self._usertype(self).__neg__()
    def __nonzero__(self): return self._usertype(self).__nonzero__()
    def __bool__(self): return self._usertype(self).__bool__()
    def __oct__(self): return self._usertype(self).__oct__()
    def __or__(self,other): return self._usertype(self).__or__(self._usertype(other))
    def __pos__(self): return self._usertype(self).__pos__()
    def __pow__(self,other): return self._usertype(self).__pow__(self._usertype(other))
    def __radd__(self,other): return self._usertype(self).__radd__(self._usertype(other))
    def __rand__(self,other): return self._usertype(self).__rand__(self._usertype(other))
    def __rdiv__(self,other): return self._usertype(self).__rdiv__(self._usertype(other))
    def __rdivmod__(self,other): return self._usertype(self).__rdivmod__(self._usertype(other))
    def __rfloordiv__(self,other): return self._usertype(self).__rfloordiv__(self._usertype(other))
    def __rlshift__(self,other): return self._usertype(self).__rlshift__(self._usertype(other))
    def __rmod__(self,other): return self._usertype(self).__rmod__(self._usertype(other))
    def __rmul__(self,other): return self._usertype(self).__rmul__(self._usertype(other))
    def __ror__(self,other): return self._usertype(self).__ror__(self._usertype(other))
    def __rpow__(self,other): return self._usertype(self).__rpow__(self._usertype(other))
    def __rrshift__(self,other): return self._usertype(self).__rrshift__(self._usertype(other))
    def __rshift__(self,other): return self._usertype(self).__rshift__(self._usertype(other))
    def __rsub__(self,other): return self._usertype(self).__rsub__(self._usertype(other))
    def __rtruediv__(self,other): return self._usertype(self).__rtruediv__(self._usertype(other))
    def __rxor__(self,other): return self._usertype(self).__rxor__(self._usertype(other))
    def __sub__(self,other): return self._usertype(self).__sub__(self._usertype(other))
    def __truediv__(self,other): return self._usertype(self).__truediv__(self._usertype(other))
    def __xor__(self,other): return self._usertype(self).__xor__(self._usertype(other))
    def __str__(self): return hex(self._usertype(self))
    def __hash__(self): return self._usertype(self)
    def __lt__(self,other): return (self._usertype(self)<other)
    def __le__(self,other): return (self._usertype(self)<=other)
    def __eq__(self,other): return (self._usertype(self)==other)
    def __ne__(self,other): return (self._usertype(self)!=other)
    def __gt__(self,other): return (self._usertype(self)>other)
    def __ge__(self,other): return (self._usertype(self)>=other)
    def __repr__(self): return hex(self._usertype(self))
    
