###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################

import traceback
from ._py2to3 import *
from . import cli_logging
_log = cli_logging.getLogger("breakpoint")

# we are trying not to return IPC specific objects back out of the ipccli
# so we have this python wrapper class that will then be overriden to make it ipccli specific
# users should never create this class. They should only be using the "baseaccess().br.new()" function
class Breakpoint(object):
    address = None
    dbreg = None
    dataSize = None
    breakType = None
    enabled = None
    deviceId = None
    breakpointId = None
    name = ""
    _env_breakpoint = None

    def __init__(self):
        pass
        # Example of likely initialization code needed
        # self._env_breakpoint = env_breakpoint
        
    def __repr__(self, *args,**kwargs):
        msg = []
        msg.append( "Breakpoint Name: {0} - Id: {1}".format(self.name,self.breakpointId) )
        msg.append("  Address: {0} - Data Size: {1} - DBReg: {2} - Enabled: {3}".format(
                    self.address, self.dataSize, self.dbreg, bool(self.enabled)))
        return "\n".join(msg)
                    
    # The following are  required attributes
    # that must be implemented per environment and match to some internal
    # function call
    @property
    def address(self):
        raise Exception("Must be implemented")
    @property
    def dbreg(self):
        raise Exception("Must be implemented")
    @property
    def breakType(self):
        raise Exception("Must be implemented")
    @property
    def enabled(self):
        raise Exception("Must be implemented")
    @property
    def deviceId(self):
        raise Exception("Must be implemented")    
    

class IaThreadBreak(object):
    """Used to display a thread's current execution status when we
    halt or hit breakpoints"""
    def __init__(self,base,device,breaktype):
        self.base = base # weakref not needed here since base does not keep reference to us
        self.device = device
        self.breaktype = breaktype
        try:
            cs = long(self.base.cmds.arch_register(self.device.did,"cs"))
            self.cs = "0x{0:04X}".format(cs)
        except:
            _log.debug(traceback.format_exc())
            self.cs = "CS Unknown"
            
        try:        
            eip = long(self.base.cmds.arch_register(self.device.did,"eip"))
            self.pp = self.eip = "0x{0:016X}".format(eip)
        except:
            _log.debug(traceback.format_exc())            
            self.pp = self.eip = "Unknown PP/EIP"
    
    def __repr__(self):
        return "{indent}[{alias}]   {breaktype} at {cs}:{pp}".format(
                indent=" "*8,
                alias=self.device.alias,
                breaktype=self.breaktype,
                cs=self.cs,pp=self.pp)
