###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################

from __future__ import absolute_import
import sys
import importlib
from . import settings

# just one environment, but this is to assist returning
# different baseaccesses
environments = {
                'ipc':"ipccli.ipc_env.ipc_baseaccess",
            }

################################################################
#
# For project specific overrides (not needed/used yet
# 
################################################################
#project_code = {
#        'ipccli.projs.'           
#   }


_base = None
_environment = None

#####################
#
#_base_env = None
#
#def get_baseaccess_env():
#    return _base_env
#
#def set_baseaccess_env(env):
#    global _base_env
#    assert env in environments,"not a known/supported environment
#    


def baseaccess(project=None,environment=None,**kwargs):
    global _base 
    if _base is not None:
        return _base

    # do not use ipc as a default argument, we may need another way to determine environment
    # and if we use openipc as default now, it will could cause confusion about how to determine the default
    if environment == None:
        _environment = environment = "ipc"
        
    # create our default environment, this should give us a 
    # base object with just commands, control variables, and a device list
    try:
        modpath = environments[environment]
        env = importlib.import_module(modpath)
    except ImportError:
        raise RuntimeError("Cannot import module {0} which is needed to continue".format(modpath))
    _base = env.baseaccess(**kwargs) # @UndefinedVariable
    # make sure base object reports its environment type
    _base.environment = _environment
    
    ####################################
    # Initialize our prompt
    # not putting in the first release
    ####################################
    if settings.PROMPT_DISPLAY and settings.EVENT_DISPLAY:
        from . import prompt_display
        prompt_display.enable()
    
    ####################################
    # initialize plugins
    ####################################
    # TBD....
    # 
    
    ####################################
    # Project specific overrides
    ####################################
    # recommend one of these ideas:
    #  -- singular "discover project" path
    #  -- every file in "project" is given the baseaccess and will
    #     check the project to add needed workarounds
    #        - allows more code reuse 
    #
    
    
    return _base

    
