###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################
from distutils import version
import re,string

class MyVersion(version.StrictVersion):
    version_re = re.compile(r'^(\d+) \. (\d+) (\. (\d+))? (([a-zA-Z-_]+)(\d+))?$', re.VERBOSE)
    def parse (self, vstring):
        match = self.version_re.match(vstring)
        if not match:
            raise ValueError("invalid version number '%s'" % vstring)

        (major, minor, patch, prerelease, prerelease_num) = \
            match.group(1, 2, 4, 6, 7)

        if patch:
            self.version = tuple(map(int, [major, minor, patch]))
        else:
            self.version = tuple(map(int, [major, minor, 0]))
        if prerelease:
            self.prerelease = (prerelease, int(prerelease_num))
        else:
            self.prerelease = None

# and now...take it over
version.StrictVersion = MyVersion

# make sure we always adhere what is supported by StrictVersion
# so we always no how to compare version strings
__classification__ = 100
__version__ = version.LooseVersion("1.2120.2297."+str(__classification__))
__revision__ = "$Revision: 482924 $"
__revision__ = __revision__.replace("$Revision:","")
__revision__ = __revision__.replace("$","")
__revision__ = __revision__.strip()

# for reference from StrictVersion:

# Version numbering for anal retentives and software idealists.
#     Implements the standard interface for version number classes as
#     described above.  A version number consists of two or three
#     dot-separated numeric components, with an optional "pre-release" tag
#     on the end.  The pre-release tag consists of the letter 'a' or 'b'
#     followed by a number.  If the numeric components of two version
#     numbers are equal, then one with a pre-release tag will always
#     be deemed earlier (lesser) than one without.
# 
#     The following are valid version numbers (shown in the order that
#     would be obtained by sorting according to the supplied cmp function):
# 
#         0.4       0.4.0  (these two are equivalent)
#         0.4.1
#         0.5a1
#         0.5b3
#         0.5
#         0.9.6
#         1.0
#         1.0.4a3
#         1.0.4b1
#         1.0.4
# 
#     The following are examples of invalid version numbers:
# 
#         1
#         2.7.2.2
#         1.3.a4
#         1.3pl1
#         1.3c4
# 
#     The rationale for this version numbering system will be explained
#     in the distutils documentation.
