###############################################################################
# Copyright 2014 2017 Intel Corporation.
#
# The source code, information and material ("Material") contained herein is
# owned by Intel Corporation or its suppliers or licensors, and title to such
# Material remains with Intel Corporation or its suppliers or licensors. The
# Material contains proprietary information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright laws and treaty
# provisions. No part of the Material may be used, copied, reproduced, modified,
# published, uploaded, posted, transmitted, distributed or disclosed in any way
# without Intel's prior express written permission.
#
# No license under any patent, copyright or other intellectual property rights
# in the Material is granted to or conferred upon you, either expressly, by
# implication, inducement, estoppel or otherwise. Any license under such
#
# intellectual property rights must be express and approved by Intel in writing.
# Unless otherwise agreed by Intel in writing, you may not remove or alter
# this notice or any other notice embedded in Materials by Intel or Intel's
# suppliers or licensors in any way.
###############################################################################

import sys
import collections

PY2 = sys.version_info[0] == 2
# support for old 2.x base classes class
if not PY2:
    basestring = str
    long = int
    buffer = memoryview
    xrange = range
    unicode = str
    raw_input = input
    string_types = (str,)
else:
    # must be 2.x
    input = raw_input
    string_types = (basestring, )
    collections.abc = type("abc", (object, ), {})
    collections.abc.Iterable = collections.Iterable

def with_metaclass(meta_class):
    def class_decorator(cls):
        class_info = vars(cls).copy()
        class_info.pop('__dict__', None)
        class_info.pop('__weakref__', None)
        return meta_class(cls.__name__, cls.__bases__, class_info)
    return class_decorator
