/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TclUtilities {
    private static final Map<String, String> escapeCharMap = new HashMap<String, String>();

    private TclUtilities() {
    }

    public static List<String> splitTclList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        try {
            String r;
            Splitter splitter = new Splitter(value);
            while ((r = splitter.nextToken()) != null) {
                result.add(r);
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static Map<String, String> splitTclMap(String value) {
        List<String> list = TclUtilities.splitTclList(value);
        if (list == null || (list.size() & 1) != 0) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); i += 2) {
            result.put(list.get(i), list.get(i + 1));
        }
        return result;
    }

    public static String makeSafeForBraces(String value) {
        if (value == null) {
            return null;
        }
        try {
            Splitter splitter = new Splitter(value);
            return splitter.safeForBraces();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String integerArrayToTclList(Integer[] v) {
        StringBuilder result = new StringBuilder();
        if (v != null) {
            for (Integer s : v) {
                if (result.length() > 0) {
                    result.append(' ');
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    public static String tclQuote(String input) {
        StringBuilder sb = new StringBuilder(input.length());
        sb.append('\"');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '{' || c == '}' || c == '\\' || c == '\"' || c == '[' || c == '$') {
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(String.format("\\u%04X", c));
        }
        sb.append('\"');
        return sb.toString();
    }

    static {
        escapeCharMap.put(" ", "--spAce--");
        escapeCharMap.put("\\", "--bacKslash--");
        escapeCharMap.put("\"", "--doublEquote--");
        escapeCharMap.put("{", "--lefTbrace--");
        escapeCharMap.put("}", "--righTbrace--");
    }

    public static interface ITclObject {
        public <T> T convert(Class<T> var1, Class<?> ... var2);
    }

    static class Splitter {
        private final String s;
        private int i;
        private final int len;

        Splitter(String s) {
            this.s = s;
            this.i = 0;
            this.len = s.length();
        }

        String nextToken() throws Exception {
            int openBraces = 0;
            boolean inQuotes = false;
            while (this.i < this.len && Character.isWhitespace(this.s.charAt(this.i))) {
                ++this.i;
            }
            if (this.i >= this.len) {
                return null;
            }
            char c = this.s.charAt(this.i);
            if (c == '{') {
                openBraces = 1;
                ++this.i;
            } else if (c == '\"') {
                inQuotes = true;
                ++this.i;
            }
            StringBuilder sbuf = new StringBuilder();
            block8: while (this.i < this.len) {
                int ii = this.i;
                c = this.s.charAt(this.i);
                ++this.i;
                switch (c) {
                    case '{': {
                        if (openBraces != 0) {
                            ++openBraces;
                        }
                        sbuf.append(c);
                        continue block8;
                    }
                    case '}': {
                        if (openBraces == 1) {
                            if (this.i < this.len && !Character.isWhitespace(this.s.charAt(this.i))) {
                                throw new Exception();
                            }
                            return sbuf.toString();
                        }
                        if (openBraces != 0) {
                            --openBraces;
                        }
                        sbuf.append(c);
                        continue block8;
                    }
                    case '\\': {
                        char bs = this.backslash();
                        if (openBraces > 0) {
                            sbuf.append(this.s.substring(ii, this.i));
                            continue block8;
                        }
                        sbuf.append(bs);
                        continue block8;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (openBraces == 0 && !inQuotes) {
                            return sbuf.toString();
                        }
                        sbuf.append(c);
                        continue block8;
                    }
                    case '\"': {
                        if (inQuotes) {
                            if (this.i < this.len && !Character.isWhitespace(this.s.charAt(this.i))) {
                                throw new Exception();
                            }
                            return sbuf.toString();
                        }
                        sbuf.append(c);
                        continue block8;
                    }
                }
                sbuf.append(c);
            }
            if (openBraces != 0 || inQuotes) {
                throw new Exception();
            }
            return sbuf.toString();
        }

        String safeForBraces() throws Exception {
            StringBuilder sbuf = new StringBuilder();
            int openBraces = 0;
            boolean inQuotes = false;
            boolean inVarName = false;
            while (this.i < this.len) {
                char c;
                while (this.i < this.len && Character.isWhitespace(c = this.s.charAt(this.i))) {
                    sbuf.append(c);
                    ++this.i;
                }
                if (this.i >= this.len) break;
                c = this.s.charAt(this.i);
                if (c == '{') {
                    openBraces = 1;
                    ++this.i;
                    sbuf.append(c);
                } else if (c == '\"') {
                    inQuotes = true;
                    ++this.i;
                    sbuf.append(c);
                }
                block10: while (this.i < this.len) {
                    int ii = this.i;
                    c = this.s.charAt(this.i);
                    ++this.i;
                    switch (c) {
                        case '{': {
                            if (inQuotes) {
                                sbuf.append('\\');
                            }
                            sbuf.append(c);
                            if (openBraces == 0) continue block10;
                            ++openBraces;
                            continue block10;
                        }
                        case '}': {
                            if (inQuotes && !inVarName) {
                                sbuf.append('\\');
                            }
                            sbuf.append(c);
                            if (inVarName) {
                                inVarName = false;
                            }
                            if (openBraces == 0 || --openBraces != 0) continue block10;
                            if (this.i >= this.len || Character.isWhitespace(this.s.charAt(this.i))) break block10;
                            throw new Exception();
                        }
                        case '\\': {
                            this.backslash();
                            sbuf.append(this.s.substring(ii, this.i));
                            continue block10;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            sbuf.append(c);
                            if (openBraces != 0 || inQuotes) continue block10;
                            break block10;
                        }
                        case '\"': {
                            sbuf.append(c);
                            if (!inQuotes) continue block10;
                            inQuotes = false;
                            if (this.i >= this.len || Character.isWhitespace(this.s.charAt(this.i))) break block10;
                            throw new Exception();
                        }
                        case '$': {
                            sbuf.append(c);
                            if (openBraces != 0 || this.i >= this.len || this.s.charAt(this.i) != '{') continue block10;
                            ++this.i;
                            sbuf.append('{');
                            inVarName = true;
                            continue block10;
                        }
                        default: {
                            sbuf.append(c);
                            continue block10;
                        }
                    }
                }
                if (openBraces == 0 && !inQuotes && !inVarName) continue;
                throw new Exception();
            }
            return sbuf.toString();
        }

        char backslash() {
            if (this.i >= this.len) {
                return '\\';
            }
            char c = this.s.charAt(this.i);
            switch (c) {
                case 'a': {
                    ++this.i;
                    return '\u0007';
                }
                case 'b': {
                    ++this.i;
                    return '\b';
                }
                case 'f': {
                    ++this.i;
                    return '\f';
                }
                case 'n': {
                    ++this.i;
                    return '\n';
                }
                case 'r': {
                    ++this.i;
                    return '\r';
                }
                case 't': {
                    ++this.i;
                    return '\t';
                }
                case 'v': {
                    ++this.i;
                    return '\u000b';
                }
                case 'x': {
                    int n;
                    int result = 0;
                    ++this.i;
                    int count = 0;
                    while (this.i < this.len && (n = this.toHex(this.s.charAt(this.i))) >= 0) {
                        ++this.i;
                        result = (result << 4) + n;
                        ++count;
                    }
                    if (count == 0) {
                        result = 120;
                    }
                    return (char)(result & 0xFF);
                }
                case 'u': {
                    int n;
                    int count;
                    int result = 0;
                    ++this.i;
                    for (count = 0; count < 4 && this.i < this.len && (n = this.toHex(this.s.charAt(this.i))) >= 0; ++count) {
                        ++this.i;
                        result = (result << 4) + n;
                    }
                    if (count == 0) {
                        result = 117;
                    }
                    return (char)result;
                }
                case '\n': 
                case '\r': {
                    if (c == '\r' && this.i + 1 < this.len && this.s.charAt(this.i + 1) == '\n') {
                        ++this.i;
                    }
                    do {
                        ++this.i;
                        c = this.s.charAt(this.i);
                    } while (this.i < this.len && (c == ' ' || c == '\t'));
                    return ' ';
                }
                case '\u0000': {
                    return '\\';
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    int n;
                    int result = 0;
                    for (int count = 0; count < 3 && this.i < this.len && (n = this.s.charAt(this.i) - 48) >= 0 && n <= 9; ++count) {
                        ++this.i;
                        result = result * 8 + n;
                    }
                    return (char)(result & 0xFF);
                }
            }
            ++this.i;
            return c;
        }

        private int toHex(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            return -1;
        }
    }
}

