/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.BoardInfo;
import com.psg.bts.ClientApp;
import com.psg.bts.DeviceInfo;
import com.psg.bts.MarkerGetInfo;
import com.psg.bts.QUARTUS;
import com.psg.bts.QuartusVersionChecker;
import com.psg.bts.TclUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class SysConService {
    protected ClientApp clientApp;
    private ServiceType serviceType;
    private DeviceType deviceType;
    private String devicePath;
    protected String servicePath;
    private int deviceIndex;
    private String pathName;
    private String typeName;
    private int baseAddr;
    private int dataSize;
    private AccessMode accessMode;
    protected String claimedServicePath;
    private BoardInfo boardInfo;

    public SysConService(ClientApp capp, ServiceType stype, DeviceType dtype, int dindex, String typename, String pathname, int addr, int size, AccessMode mode) throws IOException {
        this.clientApp = capp;
        this.serviceType = stype;
        this.deviceType = dtype;
        this.deviceIndex = dindex;
        this.typeName = typename;
        this.pathName = pathname;
        this.baseAddr = addr;
        this.dataSize = size;
        this.accessMode = mode;
        if (!this.clientApp.isConnected()) {
            throw new IOException("Failed to connect to System Console Server!\n");
        }
        this.boardInfo = this.clientApp.getMainBoardInfo();
        switch (this.deviceType) {
            case FPGA: {
                this.devicePath = this.getFpgaDevicePath();
                break;
            }
            default: {
                this.devicePath = this.getMaxDevicePath();
            }
        }
        try {
            this.servicePath = this.getServicePaths();
            if (!this.claimService()) {
                throw new IOException("Failed to claim service!\n");
            }
            String msg = String.format("Claim %s service succeed! Service path: %s, claimed path: %s.", this.serviceType.toString().toLowerCase(), this.servicePath, this.claimedServicePath);
            QUARTUS.myLogger.info(msg);
        }
        catch (IOException ex) {
            this.closeService();
            QUARTUS.myLogger.severe(ex.toString());
            String msg = String.format("Claim %s service failed! Type: %s Path: %s ", this.serviceType.toString().toLowerCase(), this.typeName, this.pathName);
            throw new IOException(msg);
        }
    }

    private String getFpgaDevicePath() {
        for (DeviceInfo fpgaInfo : this.boardInfo.getFpgaInfoArray()) {
            if (fpgaInfo.getDeviceIndex() != this.deviceIndex) continue;
            return fpgaInfo.getServicePath();
        }
        return "";
    }

    private String getMaxDevicePath() {
        for (DeviceInfo maxInfo : this.boardInfo.getMaxInfoArray()) {
            if (maxInfo.getDeviceIndex() != this.deviceIndex) continue;
            return maxInfo.getServicePath();
        }
        return "";
    }

    private boolean isServiceTypeSupported(ServiceType stype) {
        switch (stype) {
            case MASTER: 
            case SLAVE: 
            case SLD: 
            case DATA_PATTERN_CHECKER: 
            case DATA_PATTERN_GENERATOR: 
            case LOOPBACK: 
            case IO_BUS: 
            case ISSP: {
                return true;
            }
        }
        return false;
    }

    private String getServicePaths() throws IOException {
        Object tempSPathArray;
        Object sPathArray = new ArrayList();
        if (!this.isServiceTypeSupported(this.serviceType)) {
            throw new IOException("Unsupported service type!");
        }
        String resp = "";
        String cmd = QuartusVersionChecker.versionCompare(this.clientApp.getQuartusVersion(), "14.1") < 0 ? String.format("get_service_paths %s", this.serviceType.toString().toLowerCase()) : (this.typeName.isEmpty() ? String.format("get_service_paths -device %s %s", TclUtilities.tclQuote(this.devicePath), this.serviceType.toString().toLowerCase()) : String.format("get_service_paths -device %s -type %s %s", TclUtilities.tclQuote(this.devicePath), this.typeName, this.serviceType.toString().toLowerCase()));
        resp = this.clientApp.runCmd(cmd).trim();
        if (!resp.isEmpty()) {
            sPathArray = (ArrayList)TclUtilities.splitTclList(resp);
            if (QuartusVersionChecker.versionCompare(this.clientApp.getQuartusVersion(), "14.1") < 0) {
                tempSPathArray = new ArrayList();
                Iterator iterator = ((ArrayList)sPathArray).iterator();
                while (iterator.hasNext()) {
                    String tempSPath = (String)iterator.next();
                    if (!tempSPath.contains(String.format("%s/", this.devicePath))) continue;
                    ((ArrayList)tempSPathArray).add(tempSPath);
                }
                sPathArray = tempSPathArray;
            }
        }
        tempSPathArray = ((ArrayList)sPathArray).iterator();
        while (tempSPathArray.hasNext()) {
            String tempSPath = (String)tempSPathArray.next();
            if (ServiceType.SLAVE == this.serviceType && DeviceType.FPGA == this.deviceType) {
                String tempString;
                Map sPathInfo = new MarkerGetInfo(this.clientApp).getInfo(tempSPath);
                if (QuartusVersionChecker.versionCompare(this.clientApp.getQuartusVersion(), "14.1") < 0 && sPathInfo.containsKey("TYPE_NAME") && !(tempString = (String)sPathInfo.get("TYPE_NAME")).contains(this.typeName) || !sPathInfo.containsKey("FULL_HPATH") || !(tempString = (String)sPathInfo.get("FULL_HPATH")).contains(this.pathName)) continue;
                return TclUtilities.tclQuote(tempSPath.trim());
            }
            if (!tempSPath.contains(String.format("%s", this.pathName))) continue;
            return TclUtilities.tclQuote(tempSPath.trim());
        }
        String msg = String.format("Get %s service paths failed! Device: %s Type: %s ", this.serviceType.toString().toLowerCase(), TclUtilities.tclQuote(this.devicePath), this.typeName);
        throw new IOException(msg);
    }

    private boolean claimService() {
        String resp = "";
        String cmd = "";
        switch (this.serviceType) {
            case MASTER: {
                if (this.dataSize > 0) {
                    cmd = String.format("claim_service %s %s {} { { 0x%08x %d %s } }", this.serviceType.toString().toLowerCase(), this.servicePath, this.baseAddr, this.dataSize, this.accessMode.toString());
                    break;
                }
                if (this.dataSize != 0) break;
                cmd = String.format("claim_service %s %s {}", this.serviceType.toString().toLowerCase(), this.servicePath);
                break;
            }
            case SLAVE: 
            case SLD: 
            case DATA_PATTERN_CHECKER: 
            case DATA_PATTERN_GENERATOR: 
            case LOOPBACK: 
            case ISSP: {
                cmd = String.format("claim_service %s %s {}", this.serviceType.toString().toLowerCase(), this.servicePath);
                break;
            }
            case IO_BUS: {
                cmd = String.format("claim_service %s %s kit {}", this.serviceType.toString().toLowerCase(), this.servicePath);
                break;
            }
        }
        try {
            resp = this.clientApp.runCmd(cmd);
            this.claimedServicePath = resp.trim();
            return true;
        }
        catch (IOException ex) {
            QUARTUS.myLogger.severe(String.format("Failed to claim service: %s", cmd));
            return false;
        }
    }

    public final void closeService() {
        if (null != this.claimedServicePath) {
            String cmd = String.format("close_service %s %s", this.serviceType.toString().toLowerCase(), TclUtilities.tclQuote(this.claimedServicePath));
            QUARTUS.myLogger.info(cmd);
            try {
                this.clientApp.runCmd(cmd);
            }
            catch (IOException ex) {
                QUARTUS.myLogger.severe(ex.toString());
            }
        }
    }

    public static enum DeviceType {
        FPGA,
        MAX;

    }

    public static enum AccessMode {
        READONLY,
        READWRITE,
        EXCLUSIVE;

    }

    public static enum ServiceType {
        ALT_XCVR_CUSTOM,
        ALT_XCVR_RECONFIG_AEQ,
        ALT_XCVR_RECONFIG_DFE,
        ALT_XCVR_RECONFIG_EYE_VIEWER,
        ALT_XCVR_RECONFIG_MIFWRITER,
        BYTESTREAM,
        DASHBOARD,
        DATA_PATTERN_CHECKER,
        DATA_PATTERN_GENERATOR,
        DESIGN,
        DEVICE,
        GDBSERVER,
        IO_BUS,
        ISSP,
        JTAG_DEBUG,
        LOOPBACK,
        MARKER,
        MASTER,
        MONITOR,
        PACKET,
        PLUGIN,
        PROCESSOR,
        SLAVE,
        SLD,
        TRACE,
        TRACE_DB,
        TRANSCEIVER_CHANNEL_RX,
        TRANSCEIVER_CHANNEL_TX,
        TRANSCEIVER_DEBUG_LINK,
        TRANSCEIVER_RECONFIG_ANALOG;

    }
}

