/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class SimpleFuture<V>
implements Future<V> {
    private final Sync sync = new Sync();
    private static final long TEN_SECONDS = TimeUnit.SECONDS.toNanos(10L);

    public SimpleFuture() {
    }

    public SimpleFuture(V result) {
        this.set(result);
    }

    @Override
    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.isDone()) {
            return this.sync.innerGet();
        }
        try {
            return this.getInternal(false, 0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isDone()) {
            return this.sync.innerGet();
        }
        return this.getInternal(true, System.nanoTime() + unit.toNanos(timeout));
    }

    private V getInternal(boolean timed, long target) throws InterruptedException, ExecutionException, TimeoutException {
        long interval = this.getPushInterval();
        while (true) {
            this.push();
            long targetDelay = timed ? Math.max(target - System.nanoTime(), 0L) : TEN_SECONDS;
            long delay = Math.min(targetDelay, interval);
            try {
                return this.sync.innerGet(delay);
            }
            catch (TimeoutException e) {
                if (!timed || target - System.nanoTime() >= 0L) continue;
                throw e;
            }
            break;
        }
    }

    protected void push() {
    }

    protected long getPushInterval() {
        return TEN_SECONDS;
    }

    protected void done() {
    }

    public boolean set(V v) {
        return this.sync.innerSet(v, null);
    }

    public boolean setException(Throwable t) {
        return this.sync.innerSet(null, t);
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int READY = 1;
        private static final int DONE = 2;
        private static final int CANCELLED = 4;
        private V result;
        private Throwable exception;

        private Sync() {
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return (this.getState() & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        V innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        V innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        boolean innerSet(V v, Throwable t) {
            if (this.compareAndSetState(0, 1)) {
                this.result = v;
                this.exception = t;
                this.setState(2);
                this.releaseShared(0);
                SimpleFuture.this.done();
                return true;
            }
            return false;
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            if (this.compareAndSetState(0, 4)) {
                this.releaseShared(0);
                SimpleFuture.this.done();
                return true;
            }
            return false;
        }
    }
}

