/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.MsgBox;
import com.psg.bts.QUARTUS;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class QuartusVersionChecker {
    public static String getBinaryFolderName() {
        if (QuartusVersionChecker.isQuartus64BitMode()) {
            return "bin64";
        }
        return "bin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getQuartusVersion() {
        String value;
        block18: {
            value = System.getenv("QUARTUS_ROOTDIR");
            FileInputStream fstream = null;
            FilterInputStream in = null;
            BufferedReader br = null;
            try {
                String strLine;
                if (!new File(String.format("%s/version.txt", value)).exists()) break block18;
                fstream = new FileInputStream(value + "/version.txt");
                in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    if (!strLine.startsWith("Version=")) continue;
                    String version = strLine.trim().replaceAll("Version=(\\d+\\..*)", "$1");
                    if (version.isEmpty()) continue;
                    String string = version;
                    return string;
                }
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
            }
            finally {
                try {
                    if (null != br) {
                        br.close();
                    }
                    if (null != in) {
                        in.close();
                    }
                    if (null != fstream) {
                        fstream.close();
                    }
                }
                catch (IOException ex) {
                    QUARTUS.myLogger.severe(ex.toString());
                }
            }
        }
        MsgBox.warnDialog("Warning", null, "Failed to read version from $QUARTUS_ROOTDIR.", "Please use Quartus v14.1 or newer and check $QUARTUS_ROOTDIR environment variable.\n$QUARTUS_ROOTDIR should be pointed to the correct Quartus directory.\nCurrent $QUARTUS_ROOTDIR = " + value);
        return "";
    }

    public static boolean isQuartus64BitMode() {
        String value = System.getenv("QUARTUS_ROOTDIR");
        String bitMode = System.getProperty("sun.arch.data.model");
        if (bitMode.matches(".*32.*")) {
            return false;
        }
        if (bitMode.matches(".*64.*")) {
            return new File(String.format("%s/bin64", value)).exists();
        }
        MsgBox.warnDialog("Warning", null, "Failed to identify the system bit mode.", "System bit mode value is " + bitMode + "\nCurrent $QUARTUS_ROOTDIR = " + value);
        return false;
    }

    public static Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.trim().split("\\D");
        String[] vals2 = str2.trim().split("\\D");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            try {
                int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
                return Integer.signum(diff);
            }
            catch (NumberFormatException ex) {
                QUARTUS.myLogger.severe(ex.toString());
                return 0;
            }
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

