/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.AppView;
import com.psg.bts.ClientApp;
import com.psg.bts.MyLogger;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class QUARTUS
extends Application {
    private ClientApp clientApp;
    public static final Logger myLogger = MyLogger.getInstance(false);

    public void start(Stage primaryStage) throws Exception {
        this.initConnection();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("AppView.fxml"));
        Parent root = (Parent)fxmlLoader.load();
        AppView appView = (AppView)((Object)fxmlLoader.getController());
        appView.postInit(this.clientApp);
        primaryStage.setTitle("Quartus Shell");
        primaryStage.setScene(new Scene(root));
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/Quartus_prime_small_icon.png")));
        primaryStage.setOnCloseRequest(evt -> this.windowClosing((WindowEvent)evt));
        primaryStage.show();
    }

    public static void main(String[] args) {
        QUARTUS.launch((String[])args);
    }

    public void initConnection() {
        try {
            this.clientApp = new ClientApp();
            this.clientApp.connect();
        }
        catch (IOException ex) {
            myLogger.severe(ex.toString());
        }
    }

    private void windowClosing(WindowEvent evt) {
        myLogger.info("Application Window Closing...");
        try {
            if (null != this.clientApp) {
                this.clientApp.tearDown();
                for (Handler h : myLogger.getHandlers()) {
                    h.close();
                }
            }
        }
        catch (Exception ex) {
            myLogger.severe(ex.toString());
        }
        System.exit(0);
    }
}

