/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.MsgBox;
import com.psg.bts.Programmer;
import com.psg.bts.QUARTUS;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class ProgrammerView
implements Initializable {
    private double dragX;
    private double dragY;
    @FXML
    public Button buttonPause;
    @FXML
    public Button buttonConfigure;
    @FXML
    public Label labelDevice;
    @FXML
    public ComboBox comboBoxDevice;
    @FXML
    public TextField textFieldFileName;
    @FXML
    public ProgressBar progressBarConfigure;
    @FXML
    public Label labelProgress;
    public Programmer programmer;
    private File file;
    @FXML
    private AnchorPane paneTitle;
    @FXML
    private Button buttonClose;
    @FXML
    private Button buttonMinimize;
    @FXML
    private Button buttonFileChooser;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void buttonConfigureOnAction(ActionEvent evt) {
        String filePath = this.textFieldFileName.getText();
        if (null == filePath) {
            MsgBox.warnDialog("Warning", "Image file is not specified!");
            return;
        }
        this.programmer.programerAction(filePath);
    }

    @FXML
    private void buttonPauseOnAction(ActionEvent evt) {
        this.programmer.cmdShell.cancel();
    }

    public void windowClosing(WindowEvent evt) {
        this.programmer.cmdShell.cancel();
    }

    @FXML
    private void buttonFileChooserOnAction(ActionEvent evt) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select Image File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All files", new String[]{"*.*"}), new FileChooser.ExtensionFilter("SRAM object file", new String[]{"*.sof"}), new FileChooser.ExtensionFilter("Programmer Object Files", new String[]{"*.pof"})});
        if (this.file != null) {
            fileChooser.setInitialDirectory(this.file.getParentFile());
        } else {
            fileChooser.setInitialDirectory(new File("."));
        }
        this.file = fileChooser.showOpenDialog(null);
        if (this.file != null) {
            this.textFieldFileName.setText(this.file.getAbsolutePath());
        }
    }

    @FXML
    private void comboBoxDeviceOnAction(ActionEvent evt) {
        String deviceName = this.comboBoxDevice.getSelectionModel().getSelectedItem().toString();
        this.programmer.deviceIndex = Integer.decode(deviceName.replaceAll(".*\\@(\\d+)\\#.*", "$1"));
    }

    @FXML
    private void buttonCloseOnAction(ActionEvent event) {
        QUARTUS.myLogger.config("[Event -- Programmer window closing]");
        Stage stage = (Stage)((Node)event.getSource()).getScene().getWindow();
        stage.close();
    }

    @FXML
    private void buttonMinimizeOnAction(ActionEvent event) {
        QUARTUS.myLogger.config("[Event -- Programmer window minimize]");
        Stage stage = (Stage)((Node)event.getSource()).getScene().getWindow();
        stage.setIconified(true);
    }

    @FXML
    private void paneTitleOnMouseDragged(MouseEvent event) {
        Stage stage = (Stage)((Node)event.getSource()).getScene().getWindow();
        stage.setX(event.getScreenX() + this.dragX);
        stage.setY(event.getScreenY() + this.dragY);
    }

    @FXML
    private void paneTitleOnMousePressed(MouseEvent event) {
        Stage stage = (Stage)((Node)event.getSource()).getScene().getWindow();
        this.dragX = stage.getX() - event.getScreenX();
        this.dragY = stage.getY() - event.getScreenY();
    }
}

