/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.ClientApp;
import com.psg.bts.CommandShell;
import com.psg.bts.MsgBox;
import com.psg.bts.ProgrammerCallback;
import com.psg.bts.ProgrammerView;
import com.psg.bts.QUARTUS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class Programmer {
    public final CommandShell cmdShell = new CommandShell();
    private int cableIndex;
    public int deviceIndex;
    public long progressTime = 0L;
    private ScheduledThreadPoolExecutor exec;
    private Thread programThread;
    private boolean programFinished = false;
    private boolean programResult = false;
    private ProgrammerCallback callback = null;
    private ProgrammerView controller;
    private Stage stage;

    public void initComponent() {
        try {
            this.stage = new Stage();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("ProgrammerView.fxml"));
            Parent root = (Parent)fxmlLoader.load();
            Scene scene = new Scene(root);
            this.controller = (ProgrammerView)fxmlLoader.getController();
            this.controller.programmer = this;
            this.stage.setScene(scene);
            this.stage.initStyle(StageStyle.UNDECORATED);
            this.stage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("res/bts-w.png")));
            this.stage.setOnCloseRequest(evt -> this.controller.windowClosing((WindowEvent)evt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Programmer(int cIndex, int dIndex, String filePath, ProgrammerCallback cBack, int time, boolean autoRun) {
        this.cableIndex = cIndex;
        this.deviceIndex = dIndex;
        this.progressTime = time;
        this.callback = cBack;
        this.initComponent();
        this.controller.labelDevice.setVisible(false);
        this.controller.comboBoxDevice.setVisible(false);
        this.controller.buttonPause.setDisable(true);
        this.controller.textFieldFileName.setText(filePath);
        if (autoRun) {
            this.programerAction(filePath);
        }
        this.stage.showAndWait();
    }

    public Programmer(int cIndex, int dIndex, String filePath) {
        try {
            this.cmdShell.runProgram(cIndex, dIndex, filePath);
            this.programFinished = true;
            this.programResult = true;
        }
        catch (IOException | InterruptedException ex) {
            QUARTUS.myLogger.severe(ex.toString());
            this.programFinished = true;
            this.programResult = false;
        }
    }

    public Programmer(ClientApp cApp) {
        this.cableIndex = cApp.getCableIndex();
        ArrayList<String> deviceNameList = cApp.getDeviceNameList();
        this.deviceIndex = Integer.decode(deviceNameList.get(0).replaceAll(".*\\@(\\d+)\\#.*", "$1"));
        this.initComponent();
        this.controller.comboBoxDevice.getItems().addAll(deviceNameList);
        this.controller.comboBoxDevice.setValue((Object)deviceNameList.get(0));
        this.controller.buttonPause.setDisable(true);
        this.stage.showAndWait();
    }

    public void updateStatus() {
        double progress = 0.0;
        if (this.programFinished) {
            if (this.programResult) {
                this.controller.progressBarConfigure.setProgress(1.0);
                Platform.runLater(() -> this.controller.labelProgress.setText("100%"));
            } else {
                this.controller.progressBarConfigure.setProgress(0.0);
                Platform.runLater(() -> this.controller.labelProgress.setText("Failed!"));
            }
            this.exec.shutdown();
            try {
                this.exec.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                QUARTUS.myLogger.severe(ex.toString());
            }
            this.exec = null;
        } else {
            double d;
            progress = this.controller.progressBarConfigure.getProgress();
            if (0.99 > d) {
                this.controller.progressBarConfigure.setProgress(progress + 0.01);
                if (progress > 0.5) {
                    this.controller.labelProgress.setTextFill((Paint)Color.WHITE);
                }
                Platform.runLater(() -> this.controller.labelProgress.setText(Integer.toString((int)(this.controller.progressBarConfigure.getProgress() * 100.0)) + "%"));
            }
        }
    }

    public int getEstimateProgressTime(String filePath) {
        int time = 0;
        String suffix = filePath.substring(filePath.lastIndexOf(".") + 1);
        File file = new File(filePath);
        switch (suffix) {
            case "sof": {
                time = file.length() > 1473000L ? (int)(file.length() / 1473000L) : 1;
                break;
            }
            case "pof": {
                time = (int)(file.length() / 6390L);
                break;
            }
            case "cdf": {
                file = new File(filePath.substring(0, filePath.lastIndexOf(".")) + ".pof");
                if (file.exists()) {
                    time = (int)(file.length() / 468400L);
                    break;
                }
                file = new File(filePath.substring(0, filePath.lastIndexOf(".")) + ".jic");
                time = (int)(file.length() / 479300L);
                break;
            }
        }
        return time;
    }

    public void doProgram(String filePath) {
        try {
            this.programFinished = false;
            this.programResult = false;
            this.cmdShell.runProgram(this.cableIndex, this.deviceIndex, filePath);
            this.programFinished = true;
            this.programResult = true;
            Thread.sleep(500L);
        }
        catch (IOException | InterruptedException ex) {
            this.programFinished = true;
            this.programResult = false;
            String errInfo = ex.toString() + "\n\nPlease power cycle the board, restart this application and try again!\nFor further information, please check \"bts_log.txt\" file.";
            Platform.runLater(() -> MsgBox.errDialog("Exception", null, "Programming thread encountered exception!", errInfo));
        }
        Platform.runLater(() -> this.stage.close());
    }

    public void programerAction(final String filePath) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            MsgBox.errDialog("Error", "File doesn't exist or is not a file");
            return;
        }
        if (this.callback != null) {
            this.callback.closeConnections();
        }
        this.programFinished = false;
        this.programResult = false;
        this.controller.progressBarConfigure.setProgress(0.0);
        this.exec = new ScheduledThreadPoolExecutor(1);
        if (this.progressTime == 0L) {
            this.progressTime = this.getEstimateProgressTime(filePath);
        }
        long delay = this.progressTime * 1000L / 100L;
        class StatusChecker
        implements Runnable {
            StatusChecker() {
            }

            @Override
            public void run() {
                Programmer.this.updateStatus();
            }
        }
        this.exec.scheduleWithFixedDelay(new StatusChecker(), 0L, delay, TimeUnit.MILLISECONDS);
        this.programThread = new Thread("Program Thread"){

            @Override
            public void run() {
                Programmer.this.doProgram(filePath);
            }
        };
        this.programThread.setDaemon(false);
        this.programThread.start();
        this.controller.buttonConfigure.setDisable(true);
        this.controller.buttonPause.setDisable(false);
    }

    public boolean getProgramResult() {
        return this.programFinished && this.programResult;
    }
}

