/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.BoardInfo;
import com.psg.bts.ClientApp;
import com.psg.bts.MarkerGetInfo;
import com.psg.bts.QUARTUS;
import com.psg.bts.TclUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JtagInfo {
    private final ClientApp clientApp;
    private final ArrayList<Map> deviceInfoMapArray = new ArrayList();
    private final ArrayList<BoardInfo> boardInfoArray = new ArrayList();

    public JtagInfo(ClientApp cApp) {
        this.clientApp = cApp;
    }

    public void retrieveBoardsInfo() {
        this.createDeviceInfoMapArray();
        this.createBoardInfoArray();
        this.clientApp.setBoardInfoArray(this.boardInfoArray);
    }

    private void createDeviceInfoMapArray() {
        try {
            String resp = this.clientApp.runCmd("get_service_paths device");
            if (!resp.isEmpty()) {
                List<String> devicePathArray = TclUtilities.splitTclList(resp);
                for (String devicePath : devicePathArray) {
                    Map deviceInfoMap = new MarkerGetInfo(this.clientApp).getInfo(devicePath);
                    if (!deviceInfoMap.containsKey("JTAG_CABLE_NAME")) continue;
                    deviceInfoMap.put("SERVICE_PATH", devicePath);
                    this.deviceInfoMapArray.add(deviceInfoMap);
                }
                QUARTUS.myLogger.info(String.format("%d device detected: %s", devicePathArray.size(), resp));
            } else {
                QUARTUS.myLogger.severe("No device detected!");
            }
        }
        catch (IOException ex) {
            QUARTUS.myLogger.severe(ex.toString());
        }
    }

    private void createBoardInfoArray() {
        for (Map deviceInfoMap : this.deviceInfoMapArray) {
            if (!deviceInfoMap.containsKey("JTAG_CABLE_NAME") || !deviceInfoMap.containsKey("DEVICE_NAME")) continue;
            String jtagCableName = deviceInfoMap.get("JTAG_CABLE_NAME").toString();
            String deviceName = deviceInfoMap.get("DEVICE_NAME").toString().replaceAll("(.*)\\@.*", "$1");
            BoardInfo boardInfo = null;
            for (BoardInfo bdInfo : this.boardInfoArray) {
                if (!bdInfo.getJtagCableName().equals(jtagCableName)) continue;
                boardInfo = bdInfo;
                break;
            }
            if (null == boardInfo) {
                boardInfo = new BoardInfo(jtagCableName);
                this.boardInfoArray.add(boardInfo);
            }
            boardInfo.addDeviceInfo(deviceInfoMap);
            if (deviceName.matches(this.clientApp.getMaxNameRegex())) {
                boardInfo.addMaxInfo(deviceInfoMap);
            }
            if (!deviceName.matches(this.clientApp.getFpgaNameRegex())) continue;
            boardInfo.addFpgaInfo(deviceInfoMap);
        }
    }

    public ArrayList<BoardInfo> getBoardInfoArray() {
        return this.boardInfoArray;
    }
}

