/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.QUARTUS;
import java.util.Map;

public class DeviceInfo {
    private String jtagCableName = "";
    private String deviceName = "";
    private String servicePath = "";
    private int deviceIndex = 0;
    private int imageType = 0;

    public DeviceInfo(Map devInfoMap) {
        if (devInfoMap.containsKey("SERVICE_PATH")) {
            this.servicePath = devInfoMap.get("SERVICE_PATH").toString().trim();
        }
        if (devInfoMap.containsKey("JTAG_CABLE_NAME")) {
            this.jtagCableName = devInfoMap.get("JTAG_CABLE_NAME").toString().trim();
        }
        if (devInfoMap.containsKey("DEVICE_NAME")) {
            this.deviceName = devInfoMap.get("DEVICE_NAME").toString().trim();
            try {
                this.deviceIndex = Integer.decode(this.deviceName.replaceAll(".*\\@(\\d+)\\#.*", "$1"));
            }
            catch (NumberFormatException ex) {
                QUARTUS.myLogger.severe(ex.toString());
            }
        }
    }

    public String getJtagCableName() {
        return this.jtagCableName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public void setImageType(int type) {
        this.imageType = type;
    }

    public int getImageType() {
        return this.imageType;
    }
}

