/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.ClientApp;
import com.psg.bts.QUARTUS;
import java.io.File;
import java.io.IOException;

public class DesignLoader {
    private final String designFilePath;
    private final ClientApp clientApp;

    public DesignLoader(ClientApp capp, String filePath) {
        this.clientApp = capp;
        this.designFilePath = filePath;
    }

    public String loadDesign() {
        try {
            File designFile = new File(this.designFilePath);
            String resp = this.clientApp.runCmd(String.format("design_load \"%s\"", designFile.getAbsolutePath().replaceAll("\\\\", "/")));
            QUARTUS.myLogger.info(String.format("design_load %s%nResult: %s", this.designFilePath, resp));
            if (!resp.matches("error.*")) {
                return resp;
            }
        }
        catch (IOException ex) {
            QUARTUS.myLogger.severe(ex.toString());
        }
        return null;
    }
}

