/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.MsgBox;
import com.psg.bts.SimpleFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;

public class ClientLib {
    private final int serverPort;
    private SocketChannel sock;
    private final StringBuilder partialResponse = new StringBuilder();
    private final ByteBuffer respHeader;
    private ByteBuffer partialBinary;
    private final List<Response> responses = new LinkedList<Response>();
    private Thread receiveThread;
    private Mode mode = Mode.TEXT;
    private final AtomicReference<Exception> atomicReference = new AtomicReference();

    public ClientLib(int serverPort) {
        this.serverPort = serverPort;
        this.respHeader = ByteBuffer.allocate(8);
        this.respHeader.order(ByteOrder.BIG_ENDIAN);
    }

    public Future<String> sendCommand(String cmnd) throws IOException {
        return this.sendCommand(cmnd + "\n", Mode.TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<String> sendCommand(String cmnd, Mode goMode) throws IOException {
        int timeout = cmnd.length() == 0 ? 3000 : 10000;
        TextResponseFuture resp = new TextResponseFuture(timeout);
        List<Response> list = this.responses;
        synchronized (list) {
            this.responses.add(new Response(resp, goMode));
        }
        this.writeString(cmnd);
        return resp;
    }

    void writeString(String cmnd) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(cmnd.length());
        buffer.put(cmnd.getBytes());
        buffer.flip();
        this.sock.write(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ByteBuffer> sendBinary(int cmndId, ByteBuffer command) throws IOException {
        TimedSimpleFuture<ByteBuffer> resp = new TimedSimpleFuture<ByteBuffer>(ByteBuffer.class, 60000);
        List<Response> list = this.responses;
        synchronized (list) {
            this.responses.add(new Response(resp, Mode.BINARY));
        }
        ByteBuffer frame = ByteBuffer.allocate(12 + command.remaining());
        frame.order(ByteOrder.BIG_ENDIAN);
        frame.putInt(1);
        frame.putInt(4 + command.remaining());
        frame.putInt(cmndId << 16);
        frame.put(command);
        frame.flip();
        this.sock.write(frame);
        return resp;
    }

    public void sendRaw(ByteBuffer data) throws IOException {
        this.sock.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ByteBuffer> waitRaw() {
        TimedSimpleFuture<ByteBuffer> resp = new TimedSimpleFuture<ByteBuffer>(ByteBuffer.class, 60000);
        List<Response> list = this.responses;
        synchronized (list) {
            this.responses.add(new Response(resp, Mode.RAW));
        }
        return resp;
    }

    public void connect() throws IOException {
        this.sock = SocketChannel.open(new InetSocketAddress("localhost", this.serverPort));
        this.sock.finishConnect();
        this.receiveThread = new Thread("System Console Client Receive Thread"){

            @Override
            public void run() {
                try {
                    ClientLib.this.doReceiveThread();
                }
                catch (IOException e) {
                    if (e instanceof ClosedChannelException) {
                        return;
                    }
                    Platform.runLater(() -> MsgBox.warnDialog("Warning", "Failed to connect to the board. It could be caused by phisical connection issue or System-Console Server is closed.\r\nPlease check the connection and restart GUI."));
                    System.exit(0);
                }
                catch (Exception e) {
                    e.getStackTrace();
                    ClientLib.this.atomicReference.compareAndSet(null, e);
                }
            }
        };
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    public void close() throws Exception {
        Exception e = this.atomicReference.get();
        if (e != null) {
            throw e;
        }
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public boolean isConnected() {
        return this.sock != null && this.sock.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReceiveThread() throws Exception {
        ByteBuffer buff = ByteBuffer.allocate(4096);
        Selector selector = Selector.open();
        this.sock.configureBlocking(false);
        this.sock.register(selector, 1);
        while (this.sock.isConnected()) {
            int readyChannels = selector.select();
            if (readyChannels == 0) continue;
            Set<SelectionKey> selected = selector.selectedKeys();
            while (!selected.isEmpty()) {
                SelectionKey sk = selected.iterator().next();
                selected.remove(sk);
                SelectableChannel channel = sk.channel();
                if (channel != this.sock) continue;
                buff.clear();
                this.sock.read(buff);
                buff.flip();
                while (buff.hasRemaining()) {
                    Response response;
                    if (this.mode == Mode.TEXT) {
                        Matcher matcher22;
                        Response response2;
                        char c = (char)buff.get();
                        if (c == '\r') continue;
                        if (c != '\n') {
                            this.partialResponse.append(c);
                            continue;
                        }
                        String resp = this.partialResponse.toString();
                        this.partialResponse.setLength(0);
                        if (resp.equals("tcl>") || resp.length() == 0) continue;
                        List<Response> list = this.responses;
                        synchronized (list) {
                            response2 = !this.responses.isEmpty() ? this.responses.get(0) : null;
                        }
                        if (response2 == null) {
                            this.fail("Received \"" + resp + "\" but nothing expected");
                        }
                        SimpleFuture<String> future = response2.getResp(String.class);
                        if (resp.startsWith("# ")) {
                            TextResponseFuture trf = (TextResponseFuture)future;
                            trf.warnings.add(resp.substring(2));
                            continue;
                        }
                        if (resp.startsWith("puts ") && resp.endsWith("\"") && (matcher22 = Pattern.compile("puts\\s+(stdout|stderr)?\\s*\\\"(.*)").matcher(resp.substring(0, resp.length() - 1))).matches()) {
                            boolean stderr = "stderr".equals(matcher22.group(1));
                            String line = matcher22.group(2);
                            TextResponseFuture trf = (TextResponseFuture)future;
                            trf.lines.add(new OutputLine(stderr, line));
                            continue;
                        }
                        if (resp.startsWith("return \"") && resp.endsWith("\"")) {
                            future.set(this.unquote(resp.substring(8, resp.length() - 1)));
                            this.mode = response2.goMode;
                        } else if (resp.startsWith("error \"") && resp.endsWith("\"")) {
                            future.setException(new Exception(this.unquote(resp.substring(7, resp.length() - 1))));
                        } else {
                            this.fail("Received \"" + resp + "\" which is not an expected command");
                        }
                        List<Response> matcher22 = this.responses;
                        synchronized (matcher22) {
                            this.responses.remove(0);
                            continue;
                        }
                    }
                    if (this.mode == Mode.BINARY) {
                        Response response3;
                        ByteBuffer dest = this.partialBinary != null ? this.partialBinary : this.respHeader;
                        int oldLimit = buff.limit();
                        int n = Math.min(buff.remaining(), dest.remaining());
                        buff.limit(buff.position() + n);
                        dest.put(buff);
                        buff.limit(oldLimit);
                        if (dest.hasRemaining()) continue;
                        dest.flip();
                        if (this.partialBinary == null) {
                            int chan = this.respHeader.getInt();
                            if (1 != chan) {
                                this.fail(null);
                            }
                            int lenFlags = this.respHeader.getInt();
                            int len = lenFlags & 0xFFFFFF;
                            int flags = lenFlags >> 24 & 0xFF;
                            if (0 != flags) {
                                this.fail(null);
                            }
                            this.partialBinary = ByteBuffer.allocate(len);
                            continue;
                        }
                        List<Response> lenFlags = this.responses;
                        synchronized (lenFlags) {
                            response3 = !this.responses.isEmpty() ? this.responses.get(0) : null;
                        }
                        if (response3 == null) {
                            this.fail("Received " + this.partialBinary.remaining() + " byte frame but nothing expected");
                        }
                        SimpleFuture<ByteBuffer> future = response3.getResp(ByteBuffer.class);
                        this.partialBinary.getInt();
                        future.set(this.partialBinary);
                        List<Response> list = this.responses;
                        synchronized (list) {
                            this.responses.remove(0);
                        }
                        this.partialBinary = null;
                        this.respHeader.clear();
                        continue;
                    }
                    if (this.mode != Mode.RAW) continue;
                    List<Response> oldLimit = this.responses;
                    synchronized (oldLimit) {
                        response = !this.responses.isEmpty() ? this.responses.get(0) : null;
                    }
                    if (response == null) {
                        this.fail("Received " + buff.remaining() + " byte frame but nothing expected");
                    }
                    SimpleFuture<ByteBuffer> future = response.getResp(ByteBuffer.class);
                    ByteBuffer data = ByteBuffer.allocate(buff.remaining());
                    data.put(buff);
                    data.flip();
                    future.set(data);
                    List<Response> list = this.responses;
                    synchronized (list) {
                        this.responses.remove(0);
                    }
                }
            }
        }
    }

    private String unquote(String input) throws Exception {
        StringBuilder sb = new StringBuilder(input.length());
        boolean quotes = false;
        int i = 0;
        while (i < input.length()) {
            char c;
            if ((c = input.charAt(i++)) == '\\') {
                int start = i;
                char result = '\u0000';
                if ((c = input.charAt(i++)) == 'n') {
                    result = '\n';
                } else if (c == 'r') {
                    result = '\r';
                } else if (c == 'u') {
                    int k;
                    int j;
                    int cc = 0;
                    for (j = 0; j < 4 && (k = ClientLib.hexChar(input.charAt(i))) >= 0; ++j) {
                        cc = cc << 4 | k;
                        ++i;
                    }
                    if (j <= 0) {
                        this.fail("\\u not followed by hex character: " + input);
                    }
                    result = (char)cc;
                } else if (c == '{' || c == '}' || c == '\\' || c == '\"' || c == '[' || c == '$') {
                    result = c;
                } else {
                    this.fail(String.format("Unexpected escape \\%c", Character.valueOf(c)));
                }
                if (!quotes) {
                    sb.append(result);
                    continue;
                }
                sb.append(input, start, i);
                continue;
            }
            if (c == '{' || c == '}' || c == '\"' || c == '[' || c == '$') {
                this.fail(String.format("Special character \\%c was not escaped", Character.valueOf(c)));
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            this.fail(String.format("Unexpected character 0x%02X '%c'", c, Character.valueOf(c)));
        }
        return sb.toString();
    }

    private static int hexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public void waitForResponses() throws Exception {
        long timeout = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() - timeout < 0L && this.atomicReference.get() == null) {
            if (this.responses.isEmpty()) {
                return;
            }
            Thread.sleep(100L);
        }
        if (this.atomicReference.get() != null) {
            throw (Exception)this.atomicReference.getAndSet(null);
        }
        this.fail("Timed out waiting for response");
    }

    public void fail(String message) throws Exception {
        if (message == null) {
            throw new Exception();
        }
        throw new Exception(message);
    }

    public static enum Mode {
        TEXT,
        BINARY,
        RAW;

    }

    static class Response {
        final SimpleFuture<?> resp;
        final Mode goMode;

        Response(SimpleFuture<?> resp, Mode goBinary) {
            this.resp = resp;
            this.goMode = goBinary;
        }

        <T> SimpleFuture<T> getResp(Class<T> clazz) {
            return this.resp;
        }
    }

    public class TimedSimpleFuture<T>
    extends SimpleFuture<T> {
        private final long failAfter;

        public TimedSimpleFuture(Class<T> clazz, int timeout) {
            this.failAfter = System.currentTimeMillis() + (long)timeout;
        }

        @Override
        protected long getPushInterval() {
            return TimeUnit.MILLISECONDS.toNanos(100L);
        }

        @Override
        protected void push() {
            if (ClientLib.this.atomicReference.get() != null) {
                this.setException(new Exception(ClientLib.this.atomicReference.getAndSet(null)));
            }
            if (System.currentTimeMillis() - this.failAfter > 0L) {
                this.setException(new Exception("Test timed out"));
            }
        }
    }

    public class OutputLine {
        private final boolean stderr;
        private final String line;

        OutputLine(boolean stderr, String line) {
            this.stderr = stderr;
            this.line = line;
        }

        public boolean isStderr() {
            return this.stderr;
        }

        public String getLine() {
            return this.line;
        }
    }

    public class TextResponseFuture
    extends TimedSimpleFuture<String> {
        final List<OutputLine> lines;
        final List<String> warnings;

        public TextResponseFuture(int timeout) {
            super(String.class, timeout);
            this.lines = new ArrayList<OutputLine>();
            this.warnings = new ArrayList<String>();
        }

        public boolean isInterim() {
            return this.containsWarning("Multi-line command");
        }

        public boolean containsWarning(String prefix) {
            for (String warn : this.warnings) {
                if (!warn.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }

        List<OutputLine> getLines() throws Exception {
            if (!this.isDone()) {
                ClientLib.this.fail(null);
            }
            return Collections.unmodifiableList(this.lines);
        }
    }
}

