/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.BoardInfo;
import com.psg.bts.ClientLib;
import com.psg.bts.CommandShell;
import com.psg.bts.DeviceInfo;
import com.psg.bts.QUARTUS;
import com.psg.bts.QuartusVersionChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientApp {
    private int serverPort = 0;
    private ClientLib clientLib = null;
    private static final int maxPort = 65535;
    private Process proc;
    private String maxNameRegex = ".*5M.*|.*10M.*|.*VT.*";
    private String fpgaNameRegex = ".*10A.*|.*1S.*|.*10C.*|.*AG.*";
    private String jtagCableName = "";
    private ArrayList<BoardInfo> boardInfoArray;
    private final String quartusVersion = QuartusVersionChecker.getQuartusVersion();

    public ClientApp() throws IOException {
        this.serverPort = this.attachServer();
        if (65535 < this.serverPort) {
            String msg = String.format("ServerPort %s is not a valid TCP port.", this.serverPort);
            throw new IOException(msg);
        }
        this.clientLib = new ClientLib(this.serverPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int attachServer() {
        String quartus_rootdir = System.getenv("QUARTUS_ROOTDIR");
        String syscon_dir = QuartusVersionChecker.versionCompare(this.quartusVersion, "21.3") < 0 ? "sopc_builder" : "../syscon";
        Object[] commands = new String[]{String.format("%s/%s/bin/system-console", quartus_rootdir, syscon_dir), "--server"};
        BufferedReader stdInput = null;
        try {
            String output;
            QUARTUS.myLogger.info(Arrays.toString(commands));
            this.proc = new ProcessBuilder((String[])commands).start();
            Thread.sleep(10L);
            stdInput = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            QUARTUS.myLogger.info("Here is the standard output of the command:");
            while ((output = stdInput.readLine()) != null) {
                Matcher matcherPort;
                QUARTUS.myLogger.info(output);
                Matcher matcher = Pattern.compile("TCP PORT:").matcher(output);
                if (!matcher.find() || !(matcherPort = Pattern.compile("(\\d+)").matcher(output)).find()) continue;
                int n = Integer.valueOf(matcherPort.group(1));
                return n;
            }
        }
        catch (IOException | InterruptedException ex) {
            QUARTUS.myLogger.severe(ex.toString());
        }
        finally {
            if (null != stdInput) {
                try {
                    stdInput.close();
                }
                catch (IOException ex) {
                    QUARTUS.myLogger.severe(ex.toString());
                }
            }
        }
        return 65536;
    }

    public void connect() throws IOException {
        this.clientLib.connect();
    }

    public void tearDown() throws Exception {
        if (null != this.clientLib) {
            this.clientLib.close();
        }
        if (null != this.proc) {
            this.proc.destroy();
        }
    }

    public boolean isConnected() {
        if (null != this.clientLib) {
            return this.clientLib.isConnected();
        }
        return false;
    }

    public synchronized String runCmd(String cmd) throws IOException {
        if (null == this.clientLib || !this.clientLib.isConnected()) {
            throw new IOException("[CMD ERROR]: clientLib is null or not connected!");
        }
        try {
            Future<String> future = this.clientLib.sendCommand(cmd);
            String result = future.get();
            QUARTUS.myLogger.fine(String.format("CMD: %s%nRESULT: %s%n", cmd, result));
            return result;
        }
        catch (IOException | InterruptedException | ExecutionException ex) {
            QUARTUS.myLogger.fine(String.format("CMD: %s%nException: %s%n", cmd, ex.toString()));
            String msg = String.format("[CMD ERROR]: %s", cmd);
            throw new IOException(msg);
        }
    }

    public void setFpgaNameRegex(String nameRegex) {
        this.fpgaNameRegex = nameRegex;
    }

    public String getFpgaNameRegex() {
        return this.fpgaNameRegex;
    }

    public void setMaxNameRegex(String nameRegex) {
        this.maxNameRegex = nameRegex;
    }

    public String getMaxNameRegex() {
        return this.maxNameRegex;
    }

    public void setJtagCableName(String cableName) {
        this.jtagCableName = cableName;
    }

    public String getJtagCableName() {
        return this.jtagCableName;
    }

    public void setBoardInfoArray(ArrayList<BoardInfo> bdInfoArray) {
        this.boardInfoArray = bdInfoArray;
    }

    public ArrayList<BoardInfo> getBoardInfoArray() {
        return this.boardInfoArray;
    }

    public ArrayList<BoardInfo> getMatchedBoardInfoArray() {
        ArrayList<BoardInfo> matchedBoardInfoArray = new ArrayList<BoardInfo>();
        for (BoardInfo boardInfo : this.boardInfoArray) {
            boolean maxMatched = false;
            boolean fpgaMatched = false;
            for (DeviceInfo maxInfo : boardInfo.getMaxInfoArray()) {
                if (!maxInfo.getDeviceName().replaceAll("(.*)\\@.*", "$1").matches(this.maxNameRegex)) continue;
                maxMatched = true;
                break;
            }
            for (DeviceInfo fpgaInfo : boardInfo.getFpgaInfoArray()) {
                if (!fpgaInfo.getDeviceName().replaceAll("(.*)\\@.*", "$1").matches(this.fpgaNameRegex)) continue;
                fpgaMatched = true;
                break;
            }
            QUARTUS.myLogger.info(String.format("System Max matched: %s, Fpga matched: %s", maxMatched ? "true" : "false", fpgaMatched ? "true" : "false"));
            if (boardInfo.getFpgaInfoArray().isEmpty()) {
                fpgaMatched = true;
            }
            if (!maxMatched || !fpgaMatched) continue;
            matchedBoardInfoArray.add(boardInfo);
        }
        return matchedBoardInfoArray;
    }

    public BoardInfo getMainBoardInfo() {
        for (BoardInfo boardInfo : this.boardInfoArray) {
            if (!this.jtagCableName.equals(boardInfo.getJtagCableName())) continue;
            return boardInfo;
        }
        return null;
    }

    private int getCableIndexFromRemoteHosts() {
        CommandShell cmdShell = new CommandShell();
        ArrayList<String> cableList = cmdShell.listCables();
        String usbBlasterName = this.getJtagCableName().replaceAll("\\((.*)\\)", "$1").replaceAll("on localhost ", "").replaceAll("\\{(.*)\\}", "$1").trim();
        for (String cable : cableList) {
            if (!cable.replaceAll("\\[(.*)\\]", "$1").trim().contains(usbBlasterName)) continue;
            return cableList.indexOf(cable) + 1;
        }
        return 0;
    }

    private String getUsbIndexString(String jCableName) {
        if (jCableName.contains("localhost")) {
            return String.format("l%s", jCableName.replaceAll(".*USB-(\\d+).*", "$1"));
        }
        return String.format("r%s", jCableName.replaceAll(".*USB-(\\d+).*", "$1"));
    }

    public int getCableIndex() {
        String binDir = System.getenv("QUARTUS_ROOTDIR") + "/" + QuartusVersionChecker.getBinaryFolderName() + "/";
        ArrayList<String> usbIdxStrArray = new ArrayList<String>();
        try {
            Process process = new ProcessBuilder(binDir + "jtagconfig").start();
            Thread.sleep(10L);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.matches("\\d+\\) .*")) continue;
                QUARTUS.myLogger.info(line);
                if (line.contains(" on ")) {
                    usbIdxStrArray.add(String.format("r%s", line.replaceAll(".*USB-(\\d+).*", "$1")));
                    continue;
                }
                if (line.contains("USB")) {
                    usbIdxStrArray.add(String.format("l%s", line.replaceAll(".*USB-(\\d+).*", "$1")));
                    continue;
                }
                usbIdxStrArray.add("no");
            }
            br.close();
            process.destroy();
        }
        catch (IOException | InterruptedException ex) {
            QUARTUS.myLogger.severe(ex.toString());
        }
        String usbIdxStr = this.getUsbIndexString(this.jtagCableName);
        return usbIdxStrArray.indexOf(usbIdxStr) + 1;
    }

    public ArrayList<Integer> getFpgaIndexList() {
        ArrayList<Integer> deviceIndexList = new ArrayList<Integer>();
        for (DeviceInfo deviceInfo : this.getMainBoardInfo().getFpgaInfoArray()) {
            deviceIndexList.add(deviceInfo.getDeviceIndex());
        }
        return deviceIndexList;
    }

    public ArrayList<Integer> getMaxIndexList() {
        ArrayList<Integer> deviceIndexList = new ArrayList<Integer>();
        for (DeviceInfo deviceInfo : this.getMainBoardInfo().getMaxInfoArray()) {
            deviceIndexList.add(deviceInfo.getDeviceIndex());
        }
        return deviceIndexList;
    }

    public ArrayList<String> getDeviceNameList() {
        ArrayList<String> devNameList = new ArrayList<String>();
        int size = this.getMainBoardInfo().getDeviceInfoArray().size();
        int i = 0;
        while (devNameList.size() < size) {
            DeviceInfo devinfo = this.getMainBoardInfo().getDeviceInfo(i + 1);
            if (devinfo != null) {
                devNameList.add(devinfo.getDeviceName());
            }
            ++i;
        }
        return devNameList;
    }

    public String getQuartusVersion() {
        return this.quartusVersion;
    }

    public void refreshConnections() {
        try {
            this.runCmd("refresh_connections");
        }
        catch (IOException ex) {
            QUARTUS.myLogger.severe(ex.toString());
        }
    }
}

