/*
 * Decompiled with CFR 0.152.
 */
package com.psg.bts;

import com.psg.bts.ClientApp;
import com.psg.bts.JtagInfo;
import com.psg.bts.JtagSelector;
import com.psg.bts.MsgBox;
import com.psg.bts.Programmer;
import com.psg.bts.QUARTUS;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;

public class AppView
extends BorderPane
implements Initializable {
    @FXML
    public TextField textFieldCmd;
    @FXML
    private TextArea textAreaOutput;
    private ClientApp clientApp;

    public void postInit(ClientApp cApp) {
        this.clientApp = cApp;
        this.textFieldCmd.requestFocus();
    }

    @FXML
    private void textFieldCmdOnAction(ActionEvent evt) {
        String resp = "";
        String enter = System.getProperty("line.separator");
        try {
            resp = this.clientApp.runCmd(this.textFieldCmd.getText());
        }
        catch (IOException ex) {
            QUARTUS.myLogger.severe(ex.toString());
            this.textAreaOutput.appendText("$ " + this.textFieldCmd.getText() + enter + ex.toString() + enter);
            return;
        }
        this.textAreaOutput.appendText("$ " + this.textFieldCmd.getText() + enter + resp + enter);
    }

    @FXML
    private void buttonProgrammerOnAction(ActionEvent evt) throws IOException {
        JtagInfo jtagInfo = new JtagInfo(this.clientApp);
        jtagInfo.retrieveBoardsInfo();
        JtagSelector jtagSelector = new JtagSelector(this.clientApp);
        String jtagCableName = jtagSelector.getMainJtagCableName();
        if (jtagCableName.isEmpty()) {
            MsgBox.warnDialog("Warning", "No device detected");
            return;
        }
        QUARTUS.myLogger.info(String.format("Selected JTAG cable is: %s", jtagCableName));
        this.clientApp.setJtagCableName(jtagCableName);
        Programmer programmer = new Programmer(this.clientApp);
    }

    public void initialize(URL url, ResourceBundle rb) {
    }
}

