/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bts;

import com.intel.bts.ClientApp;
import com.intel.bts.SysConService;
import com.intel.bts.TclUtilities;
import java.io.IOException;

public class SldService
extends SysConService {
    public SldService(ClientApp capp, SysConService.DeviceType dtype, int dindex, String tname, String sname) throws IOException {
        super(capp, SysConService.ServiceType.SLD, dtype, dindex, tname, sname, 0, 0, SysConService.AccessMode.EXCLUSIVE);
    }

    public byte[] sldAccessDrBytes(byte[] dataArray, boolean readFlag) throws IOException {
        if (0 != dataArray.length) {
            StringBuilder buf = new StringBuilder();
            for (byte data : dataArray) {
                buf.append(String.format("0x%02x ", data));
            }
            String dataStr = buf.toString();
            String resp = this.clientApp.runCmd(String.format("sld_access_dr %s %s 0 { %s }", TclUtilities.tclQuote(this.claimedServicePath), Integer.toString(dataArray.length * 8), dataStr));
            if (readFlag) {
                String[] respStrArray = resp.trim().split(" ");
                byte[] respBytes = new byte[respStrArray.length];
                int counter = 0;
                for (String respStr : respStrArray) {
                    respBytes[counter++] = Integer.decode(respStr).byteValue();
                }
                return respBytes;
            }
        }
        return new byte[0];
    }

    public byte[] sldAccessDrBits(byte data, int numOfBits, boolean readFlag) throws IOException {
        String dataStr = String.valueOf(data);
        String resp = this.clientApp.runCmd(String.format("sld_access_dr %s %s 0 { %s }", TclUtilities.tclQuote(this.claimedServicePath), numOfBits, dataStr));
        if (readFlag) {
            String[] respStrArray = resp.trim().split(" ");
            byte[] respBytes = new byte[respStrArray.length];
            int counter = 0;
            for (String respStr : respStrArray) {
                respBytes[counter++] = Integer.decode(respStr).byteValue();
            }
            return respBytes;
        }
        return new byte[0];
    }

    public void sldAccessDrBitsWrite(byte data, int numOfBits) throws IOException {
        this.sldAccessDrBits(data, numOfBits, false);
    }

    public byte[] sldAccessDrBytesRead(int length) throws IOException {
        byte[] tempData = new byte[length];
        return this.sldAccessDrBytes(tempData, true);
    }

    public void sldAccessDrBytesWrite(byte[] dataArray) throws IOException {
        this.sldAccessDrBytes(dataArray, false);
    }

    public byte sldAccessDrReadInByte() throws IOException {
        byte[] tempData = new byte[]{0};
        tempData = this.sldAccessDrBytes(tempData, true);
        return tempData[0];
    }

    public void sldAccessDrWriteInByte(byte data) throws IOException {
        byte[] dataArray = new byte[]{data};
        this.sldAccessDrBytes(dataArray, false);
    }

    public byte sldAccessDrInByte(byte data) throws IOException {
        byte[] dataArray = new byte[]{data};
        dataArray = this.sldAccessDrBytes(dataArray, true);
        return dataArray[0];
    }

    public int sldAccessIr(int data) throws IOException {
        String resp = this.clientApp.runCmd(String.format("sld_access_ir %s %d 0", TclUtilities.tclQuote(this.claimedServicePath), data));
        return Long.decode(resp).byteValue();
    }

    public void sldLock(int timeout) throws IOException {
        this.clientApp.runCmd(String.format("sld_lock %s %d", TclUtilities.tclQuote(this.claimedServicePath), timeout));
    }

    public void sldUnlock() throws IOException {
        this.clientApp.runCmd(String.format("sld_unlock %s", TclUtilities.tclQuote(this.claimedServicePath)));
    }

    public void sldAccessDrWriteString(String data) throws IOException {
        if (null != data && !data.isEmpty()) {
            this.clientApp.runCmd(String.format("sld_access_dr %s %d 0 { %s }", TclUtilities.tclQuote(this.claimedServicePath), data.length() * 8 / 5, data));
        }
    }
}

