/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bts;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.StageStyle;

public class MsgBox {
    public static Alert alertBox(Alert.AlertType type, String title, String header, String content) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.initStyle(StageStyle.UTILITY);
        return alert;
    }

    public static Alert alertExpandDialog(Alert.AlertType type, String title, String header, String content, String expand) {
        Alert alert = MsgBox.alertBox(type, title, header, content);
        if (expand != null) {
            TextArea textArea = new TextArea(expand);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)textArea, 0, 0);
            alert.getDialogPane().setExpandableContent((Node)expContent);
        }
        return alert;
    }

    public static void infoDialog(String title, String content) {
        Alert alert = MsgBox.alertBox(Alert.AlertType.INFORMATION, title, null, content);
        alert.showAndWait();
    }

    public static void infoDialog(String title, String header, String content, String expand) {
        Alert alert = MsgBox.alertExpandDialog(Alert.AlertType.INFORMATION, title, header, content, expand);
        alert.showAndWait();
    }

    public static void warnDialog(String title, String content) {
        Alert alert = MsgBox.alertBox(Alert.AlertType.WARNING, title, null, content);
        alert.showAndWait();
    }

    public static void warnDialog(String title, String header, String content, String expand) {
        Alert alert = MsgBox.alertExpandDialog(Alert.AlertType.WARNING, title, header, content, expand);
        alert.showAndWait();
    }

    public static void errDialog(String title, String content) {
        Alert alert = MsgBox.alertBox(Alert.AlertType.ERROR, title, null, content);
        alert.showAndWait();
    }

    public static void errDialog(String title, String header, String content, String expand) {
        Alert alert = MsgBox.alertExpandDialog(Alert.AlertType.ERROR, title, header, content, expand);
        alert.showAndWait();
    }

    public static boolean confirmDialog(String title, String content) {
        Alert alert = MsgBox.alertBox(Alert.AlertType.CONFIRMATION, title, null, content);
        Optional result = alert.showAndWait();
        return result.get() == ButtonType.OK;
    }

    public static boolean confirmDialog(String title, String header, String content) {
        Alert alert = MsgBox.alertBox(Alert.AlertType.CONFIRMATION, title, header, content);
        Optional result = alert.showAndWait();
        return result.get() == ButtonType.OK;
    }

    public static void exceptDialog(String title, String header, String content, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String exText = sw.toString();
        Alert alert = MsgBox.alertExpandDialog(Alert.AlertType.ERROR, title, header, content, exText);
        alert.showAndWait();
    }
}

