/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bts;

import com.intel.bts.AppMain;
import com.intel.bts.ClientApp;
import com.intel.bts.JtagSelectorController;
import com.intel.bts.JtagSelectorLib;
import java.io.IOException;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class JtagSelector {
    private String mainJtagCable = "";
    private ArrayList<String> jtagCableArray;
    private JtagSelectorLib jtagSelectorLib;
    private final ClientApp clientApp;
    private JtagSelectorController controller;
    private Stage stage;

    public JtagSelector(ClientApp cApp) {
        this.clientApp = cApp;
        try {
            this.jtagSelectorLib = new JtagSelectorLib(this.clientApp);
            this.jtagCableArray = this.jtagSelectorLib.listJtagCables();
            if (1 < this.jtagCableArray.size()) {
                this.initComponents(this.jtagCableArray);
            } else if (1 == this.jtagCableArray.size()) {
                this.mainJtagCable = this.jtagCableArray.get(0);
            }
        }
        catch (IOException ex) {
            AppMain.myLogger.severe(ex.toString());
        }
    }

    public String getMainJtagCableName() {
        return this.mainJtagCable;
    }

    public void refresh() {
        this.clientApp.refreshConnections();
        this.jtagCableArray = this.jtagSelectorLib.listJtagCables();
        ObservableList data = FXCollections.observableArrayList();
        for (int i = 0; i < this.jtagCableArray.size(); ++i) {
            data.add((Object)new UsbBlaster(Integer.toString(i + 1), this.jtagCableArray.get(i)));
        }
        this.controller.tableViewUsbBlaster.setItems(data);
    }

    public void connect() {
        this.mainJtagCable = this.controller.tableViewUsbBlaster.getSelectionModel().getSelectedItem() != null ? ((UsbBlaster)this.controller.tableViewUsbBlaster.getSelectionModel().getSelectedItem()).getCableName() : ((UsbBlaster)this.controller.tableViewUsbBlaster.getFocusModel().getFocusedItem()).getCableName();
        this.stage.close();
    }

    public void initComponents(ArrayList<String> strings) {
        try {
            this.stage = new Stage();
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("JtagSelector.fxml"));
            Parent root = (Parent)fxmlLoader.load();
            Scene scene = new Scene(root, 402.0, (double)(strings.size() * 24 + 95));
            this.controller = (JtagSelectorController)fxmlLoader.getController();
            this.controller.jtagSelector = this;
            ObservableList data = FXCollections.observableArrayList();
            for (int i = 0; i < strings.size(); ++i) {
                data.add((Object)new UsbBlaster(Integer.toString(i + 1), strings.get(i)));
            }
            this.controller.tableViewUsbBlaster.setPrefHeight((double)(strings.size() * 24 + 26));
            this.controller.tableViewUsbBlaster.setItems(data);
            this.stage.setScene(scene);
            this.stage.setTitle("JTAG Cable Selector");
            this.stage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("res/Quartus_prime_small_icon.png")));
            this.stage.setOnCloseRequest(evt -> this.connect());
            this.stage.showAndWait();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class UsbBlaster {
        private final SimpleStringProperty cableNumber;
        private final SimpleStringProperty cableName;

        public UsbBlaster(String number, String name) {
            this.cableNumber = new SimpleStringProperty(number);
            this.cableName = new SimpleStringProperty(name);
        }

        public String getCableNumber() {
            return this.cableNumber.get();
        }

        public void setCableNumber(String number) {
            this.cableNumber.set(number);
        }

        public String getCableName() {
            return this.cableName.get();
        }

        public void setCableName(String name) {
            this.cableName.set(name);
        }
    }
}

